<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Tipocontato[]|\Cake\Collection\CollectionInterface $tipocontato
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Tipo Contato') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('tipocontatoid',['label'=>'Cód']) ?></th>
                <th scope="col"><?= $this->Paginator->sort('nome') ?></th>
                <th scope="col"><?= $this->Paginator->sort('descricao',['label'=>'Descrição']) ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($tipocontato as $tipocontato): ?>
            <tr style="cursor:pointer" onclick="window.location.href='tipocontato/view/<?=$tipocontato->tipocontatoid?>'">
                <td><?= $this->Number->format($tipocontato->tipocontatoid) ?></td>
                <td><?= h($tipocontato->nome) ?></td>
                <td><?= h($tipocontato->descricao) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->numbers() ?>&nbsp;&nbsp;
            <?= $this->Paginator->next(__('próximo') . ' >') ?>&nbsp;&nbsp;
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
