<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Tipocontato $tipocontato
 */
?>
<div class="card">
<div class="card-header">
	<h3>Tipocontato <?= h($tipocontato->tipocontatoid) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $tipocontato->tipocontatoid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $tipocontato->tipocontatoid], ['confirm' => __('Deseja deletar # {0}?', $tipocontato->tipocontatoid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Nome') ?></th>
            <td><?= h($tipocontato->nome) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Descricao') ?></th>
            <td><?= h($tipocontato->descricao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Tipocontatoid') ?></th>
            <td><?= $this->Number->format($tipocontato->tipocontatoid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Empresaid') ?></th>
            <td><?= $this->Number->format($tipocontato->empresaid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pessoaidcadastro') ?></th>
            <td><?= $this->Number->format($tipocontato->pessoaidcadastro) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criacao') ?></th>
            <td><?= h($tipocontato->data_criacao) ?></td>
        </tr>
    </table>
</div>
</div>
