<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Tipotelefone $tipotelefone
 */
?>
<div class="card">
<div class="card-header">
	<h3>Tipotelefone <?= h($tipotelefone->tipotelefoneid) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $tipotelefone->tipotelefoneid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $tipotelefone->tipotelefoneid], ['confirm' => __('Deseja deletar # {0}?', $tipotelefone->tipotelefoneid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Nome') ?></th>
            <td><?= h($tipotelefone->nome) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Descricao') ?></th>
            <td><?= h($tipotelefone->descricao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Tipotelefoneid') ?></th>
            <td><?= $this->Number->format($tipotelefone->tipotelefoneid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pessoaidcadastro') ?></th>
            <td><?= $this->Number->format($tipotelefone->pessoaidcadastro) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Empresaid') ?></th>
            <td><?= $this->Number->format($tipotelefone->empresaid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criacao') ?></th>
            <td><?= h($tipotelefone->data_criacao) ?></td>
        </tr>
    </table>
</div>
</div>
