<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cliente $cliente
 */
?>
<div class="card">
<div class="card-header">
		<h3>Cadastrar Cliente</h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($cliente) ?>
		<div class="row">
			<div class="col-md-6">
			<?php
				//administrador de sistema e secretaria de sistema
				if(in_array($perfilid,[1,7])){
					$empresas = $this->Custom->getAllTableWhere('empresa_crm',[],['nomefantasia'=>'asc']);
					echo "<label>Empresa</label>";
					echo "<select name='empresaid' id='selectempresa_modal' class='form-control' onchange=\"updateVendedores('vendedores')\">";
						echo "<option disabled value='0'>.: Selecione uma opção :.</option>";
					foreach($empresas as $item){
						$selected = '';
						if($item->empresaid == $cliente->empresaid){
							$selected = 'selected';
						}
						echo "<option value='".$item->empresaid."' $selected>".$item->nomefantasia."</option>";
					}
					echo "</select>";
				} else if (in_array($perfilid,[3])) { ?>
					<div class="col-md-12">
						<?php
							$empresa_login = $this->Custom->empresaid(); 
							if(in_array($perfilid,[1,2,3,4,6])){
								$sql = "
									select
									v.idvendedor
									,p.nome
									from
									vendedor v
									inner join pessoa p on p.pessoaid = v.pessoaid
									where v.idempresa_crm = ".$empresa_login."
									order by p.nome
								";
								$vendedores = $this->Custom->query($sql);
								echo "<label>Vendedor Responsável</label>";
								echo "<select name='vendedorid' class='form-control'>";
									echo "<option value=''>.: Selecione uma opção :.</option>";
								foreach($vendedores as $item){
										$selected = '';
										if($item->idvendedor == $contatofilho->vendedorid){
											$selected = 'selected';
										}
										echo "<option value='".$item->idvendedor."' $selected>".$item->nome."</option>";
									}
									echo "</select>";
		
								}
						?>
					</div>
				<?php }
			?>
			</div>
			<div class="col-md-6" id="vendedores">
			</div>
		</div>
		<br>
		<div class="media align-items-stretch" style="box-shadow: 0 2px 0px 0 rgba(0,0,0,0.2),0 6px 10px 0 rgba(0,0,0,0.19) !important;">
			<div class="media-middle">
				&nbsp;&nbsp;<i class="fa fa-user"></i>
			</div>
			<div class="media-body">
			  <h5>&nbsp;&nbsp;Dados Pessoais</h5>
			</div>
			<div id="btntoggleup1" class="media-right media-middle" style="cursor:pointer" onclick="$(this).hide();$('#btntoggledown1').show();$('#togglecontent1').slideUp();">
				<i class="fa fa-arrow-up"></i>
			</div>
			<div id="btntoggledown1" class="media-right media-middle" style="cursor:pointer;display:none" onclick="$(this).hide();$('#btntoggleup1').show();$('#togglecontent1').slideDown();">
				<i class="fa fa-arrow-down"></i>
			</div>
			&nbsp;&nbsp;
		</div>
		<br>
		<div class="row" id="togglecontent1">
		<div class="col-md-6">
        <?php
			$tipocliente = $this->Custom->getAllTableWhere('tipocliente',[],['ordem'=>'asc']);
			echo $this->Form->control('coderp',['class'=>'form-control','label'=>'Cód. no ERP']);
			echo $this->Form->control('nome',['class'=>'form-control','label'=>'Nome/Nome Fantasia']);
			echo $this->Form->control('razaosocial',['class'=>'form-control','label'=>'Nome Social/Razão Social']);
			echo $this->Form->control('cpfcnpj',['class'=>'form-control','label'=>'CPF/CNPJ','onkeypress'=>'if(this.value.length < 14) { $(this).mask("000.000.000-00"); } else {$(this).mask("00.000.000/0000-00");}']);
			echo $this->Form->control('datanascimento',['class'=>'form-control maskdate','label'=>'Data de nascimento']);
			
			echo "<label>Tipo Cliente</label>";
			echo "<select name='tipocliente' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($tipocliente as $item){
				echo "<option value='".$item->nome."'>".$item->nome."</option>";
			}
			echo "</select>";
			
			
			$origemlead = $this->Custom->getAllTableWhere('origemlead',[],['ordem'=>'asc']);
			echo "<label>Origem Lead</label>";
			echo "<select name='origemlead' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($origemlead as $item){
				echo ($item->nome == 'Ligação Recebida') ? "<option selected value='".$item->nome."'>".$item->nome."</option>" : "<option value='".$item->nome."'>".$item->nome."</option>";
			}
			echo "</select>";
			
			$tipolead = $this->Custom->getAllTableWhere('tipolead',[],['ordem'=>'asc']);
			echo "<label>Tipo Lead</label>";
			echo "<select name='tipolead' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($tipolead as $item){
				echo "<option value='".$item->nome."'>".$item->nome."</option>";
			}
			echo "</select>";

			
            echo "<label>Cliente Ativo</label>";
			echo "<select name='ativo' class='form-control'>";
				echo "<option value='1'>Sim</option>";
				echo "<option value='0'>Não</option>";
			echo "</select>";
			
			echo $this->Form->control('data_cliente', ['type'=>'text','class'=>'form-control maskdate','label'=>'Data em que se tornou cliente']);
			
			echo "<label>Tipo Pessoa</label>";
			echo "<select name='tipopessoa' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
				echo "<option value='FÍSICA'>Física</option>";
				echo "<option value='JURÍDICA'>Jurídica</option>";
			echo "</select>";
			
			
			echo "<label>Regime Tributário</label>";
			echo "<select name='sexo' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
				echo "<option >Simples</option>";
				echo "<option >Lucro Real</option>";
				echo "<option >Lucro Presumido</option>";
			echo "</select>";
		?>
		</div>
		<div class="col-md-6">
			<label>Segmento de Atuação</label>
			<select name="segmento" class="form-control" >
				<option value=''>.: Selecione uma opção :.</option>
				<?php 
						foreach($segmento as $segmento){
							echo "<option value='".$segmento->nome."' $selected>".$segmento->nome."</option>";
						} ?>
			</select>
		<?php
			echo $this->Form->control('dependentes',['class'=>'form-control masknumber','label'=>'Qtd. de Empresas']);
			echo $this->Form->control('email',['class'=>'form-control']);
            // echo $this->Form->control('datanascimento', ['class'=>'form-control maskdate','label'=>'Data de Nascimento']);
            // echo $this->Form->control('cidade',['class'=>'form-control','label'=>'Cidade de Nascimento']);
            // echo $this->Form->control('estado',['class'=>'form-control','label'=>'Estado de Nascimento']);
            // echo $this->Form->control('pais',['value'=>'Brasil','class'=>'form-control','label'=>'País de Nascimento']);
            echo $this->Form->control('cargo',['class'=>'form-control','label'=>'Cargo/Profissão']);
            echo $this->Form->control('nomemae',['class'=>'form-control','label'=>'Nome do Responsável']);
			echo $this->Form->control('cpfmae',['class'=>'form-control','onkeypress'=>'$(this).mask("(00) 00000-0000")','label'=>'Telefone do Responsável']);
        ?>
		</div>
		</div>
	<br>
	<div class="media align-items-stretch" style="box-shadow: 0 2px 0px 0 rgba(0,0,0,0.2),0 6px 10px 0 rgba(0,0,0,0.19) !important;">
		<div class="media-middle">
			&nbsp;&nbsp;<i class="fa fa-phone"></i>
		</div>
		<div class="media-body">
		  <h5>&nbsp;&nbsp;Telefone</h5>
		</div>
		<div id="btntoggleup2" class="media-right media-middle" style="cursor:pointer" onclick="$(this).hide();$('#btntoggledown2').show();$('#togglecontent2').slideUp();">
			<i class="fa fa-arrow-up"></i>
		</div>
		<div id="btntoggledown2" class="media-right media-middle" style="cursor:pointer;display:none" onclick="$(this).hide();$('#btntoggleup2').show();$('#togglecontent2').slideDown();">
			<i class="fa fa-arrow-down"></i>
		</div>
		&nbsp;&nbsp;
	</div>
	<br>
	<div class="row" id="togglecontent2">
		<div class="col-md-12">
		<div class="input-group">
			<select name="tipotelefone1">
				<?php
					$tipotelefone = $this->Custom->getAllTableWhere('tipotelefone',[],['nome'=>'asc']);
					foreach($tipotelefone as $item){
						echo "<option value='".$item->nome."'>".$item->nome."</option>";
					}
				?>
			</select>
			<input type="number" name="codigopais1" class="form-control " placeholder="Código do país +55" value="55"/>
			<input type="text" name="ddd1" class="form-control"onkeypress="$(this).mask('(00)');" placeholder="DDD (xx)"/>
			<input type="text" name="telnumero1" class="form-control" onkeypress="$(this).mask('00000-0000', {reverse: true})" placeholder="Número xxxxx-xxxx"/>
		</div>
	
		<div class="input-group">
			<select name="tipotelefone2">
				<?php
					$tipotelefone = $this->Custom->getAllTableWhere('tipotelefone',[],['nome'=>'asc']);
					foreach($tipotelefone as $item){
						echo "<option value='".$item->nome."'>".$item->nome."</option>";
					}
				?>
			</select>
			<input type="number" name="codigopais2" class="form-control" placeholder="Código do país +55" value="55">
			<input type="text" name="ddd2" class="form-control" onkeypress="$(this).mask('(00)');" placeholder="DDD (xx)" />
			<input type="text" name="telnumero2" class="form-control" onkeypress="$(this).mask('00000-0000', {reverse: true})" placeholder="Número xxxxx-xxxx"/>
		</div>
		
		<div class="input-group">
			<select name="tipotelefone3">
				<?php
					$tipotelefone = $this->Custom->getAllTableWhere('tipotelefone',[],['nome'=>'asc']);
					foreach($tipotelefone as $item){
						echo "<option value='".$item->nome."'>".$item->nome."</option>";
					}
				?>
			</select>
			<input type="number" name="codigopais3" class="form-control" placeholder="Código do país +55" value="55">
			<input type="text" name="ddd3" class="form-control" onkeypress="$(this).mask('(00)');" placeholder="DDD (xx)" />
			<input type="text" name="telnumero3" class="form-control" onkeypress="$(this).mask('00000-0000', {reverse: true})" placeholder="Número xxxxx-xxxx"/>
		</div>
		</div>
	</div>
	<br>
	<div class="media align-items-stretch" style="box-shadow: 0 2px 0px 0 rgba(0,0,0,0.2),0 6px 10px 0 rgba(0,0,0,0.19) !important;">
		<div class="media-middle">
			&nbsp;&nbsp;<i class="fa fa-map"></i>
		</div>
		<div class="media-body">
		  <h5>&nbsp;&nbsp;Endereços</h5>
		</div>
		<div id="btntoggleup3" class="media-right media-middle" style="cursor:pointer" onclick="$(this).hide();$('#btntoggledown3').show();$('#togglecontent3').slideUp();">
			<i class="fa fa-arrow-up"></i>
		</div>
		<div id="btntoggledown3" class="media-right media-middle" style="cursor:pointer;display:none" onclick="$(this).hide();$('#btntoggleup3').show();$('#togglecontent3').slideDown();">
			<i class="fa fa-arrow-down"></i>
		</div>
		&nbsp;&nbsp;
	</div>
	<br>
	<div id="togglecontent3">
	<div class="row" >
		<div class="col-md-6">
		<?php
			$tipoendereco = $this->Custom->getAllTableWhere('tipoendereco',[],['nome'=>'asc']);
			echo "<label>Tipo Endereco</label>";
			echo "<select name='tipoendereco1' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($tipoendereco as $item){
				echo "<option value='".$item->nome."'>".$item->nome."</option>";
			}
			echo "</select>";
			
			echo $this->Form->control('cep1',['label'=>'CEP','class'=>'form-control maskcep', 'placeholder'=>'Informe o CEP para carregar o endereço','onkeyup'=>'getEnderecoCorreios1(this)', 'autocomplete'=>'off']);
			echo $this->Form->control('logradouro1',['class'=>'form-control','label'=>'Logradouro']);
			echo $this->Form->control('cidade1',['class'=>'form-control','label'=>'Cidade']);
			echo $this->Form->control('estado1',['class'=>'form-control','label'=>'Estado']);
			echo $this->Form->control('pais1',['value'=>'Brasil','class'=>'form-control','label'=>'País']);
		?>
		</div>
		<div class="col-md-6">
		<?php
			echo $this->Form->control('bairro1',['class'=>'form-control','label'=>'Bairro']);
			echo $this->Form->control('numero1',['class'=>'form-control','label'=>'Número']);
			echo $this->Form->control('complemento1',['class'=>'form-control','label'=>'Complemento']);
			echo $this->Form->control('observacoes1',['type'=>'textarea','class'=>'form-control','label'=>'Observação']);
			echo $this->Form->control('latlong1',['class'=>'form-control','label'=>'Latitude/Longitude']);
		?>
		</div>
		<div class="col-md-6 mt-1">
		<button type="button" onclick="$('#endereco2').show();$(this).hide()" class="btn btn-primary"><i class="fa fa-plus"></i> Cadastrar outro endereço</button>
		</div>
	</div>
	<hr>
	<div style="display:none" id="endereco2" class="row">
		<div class="col-md-6">
			<?php
				$tipoendereco = $this->Custom->getAllTableWhere('tipoendereco',[],['nome'=>'asc']);
				echo "<label>Tipo Endereco</label>";
				echo "<select name='tipoendereco2' class='form-control'>";
					echo "<option value=''>.: Selecione uma opção :.</option>";
				foreach($tipoendereco as $item){
					echo "<option value='".$item->nome."'>".$item->nome."</option>";
				}
				echo "</select>";
				
				echo $this->Form->control('cep2',['label'=>'CEP','class'=>'form-control maskcep', 'placeholder'=>'Informe o CEP para carregar o endereço','onkeyup'=>'getEnderecoCorreios2(this)', 'autocomplete'=>'off']);
				echo $this->Form->control('logradouro2',['class'=>'form-control','label'=>'Logradouro']);
				echo $this->Form->control('cidade2',['class'=>'form-control','label'=>'Cidade']);
				echo $this->Form->control('estado2',['class'=>'form-control','label'=>'Estado']);
				echo $this->Form->control('pais2',['value'=>'Brasil','class'=>'form-control','label'=>'País']);
			?>
			</div>
			<div class="col-md-6">
			<?php
				echo $this->Form->control('bairro2',['class'=>'form-control','label'=>'Bairro']);
				echo $this->Form->control('numero2',['class'=>'form-control','label'=>'Número']);
				echo $this->Form->control('complemento2',['class'=>'form-control','label'=>'Complemento']);
				echo $this->Form->control('observacoes2',['type'=>'textarea','class'=>'form-control','label'=>'Observação']);
				echo $this->Form->control('latlong2',['class'=>'form-control','label'=>'Latitude/Longitude']);
			?>
			</div>
	</div>
	</div>
    <br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary','id'=>'btn']) ?>
    <?= $this->Form->end() ?>
</div>
</div>

<script>
$( "form" ).submit(function() {
  $("#btn").attr('disabled','disabled');
});
</script>

<script>
$('label').css('padding-top','5px')
</script>
<script>
function getEnderecoCorreios1(el){
	if(el.value.replace('-','').length >= 8){
		$('#loading').show();
		$.getJSON( window.location.protocol+"//api.postmon.com.br/v1/cep/"+el.value.replace('-',''), function( data ) {
			$('#loading').hide();
			if(data.bairro){
				$('input[name="bairro1"]').val(data.bairro);
			}else{
				$('input[name="bairro1"]').val("Sem bairro");
			}
			if(data.logradouro){
				$('input[name="logradouro1"]').val(data.logradouro);
			}else{
				$('input[name="logradouro1"]').val("Sem logradouro");
			}
			
			$('input[name="cidade1"]').val(data.cidade);
			$('input[name="estado1"]').val(data.estado);
		}).fail(function() {
			$('#loading').hide();
			$('input[name="cep1"]').val('');
			$('input[name="bairro1"]').val('');
			$('input[name="cidade1"]').val('');
			$('input[name="logradouro1"]').val('');
			$('input[name="estado1"]').val('');
			alert('CEP não encontrado. Informe outro.');
		});
	}
}

function getEnderecoCorreios2(el){
	if(el.value.replace('-','').length >= 8){
		$('#loading').show();
		$.getJSON( window.location.protocol+"//api.postmon.com.br/v1/cep/"+el.value.replace('-',''), function( data ) {
			$('#loading').hide();
			if(data.bairro){
				$('input[name="bairro2"]').val(data.bairro);
			}else{
				$('input[name="bairro2"]').val("Sem bairro");
			}
			if(data.logradouro){
				$('input[name="logradouro2"]').val(data.logradouro);
			}else{
				$('input[name="logradouro2"]').val("Sem logradouro");
			}
			
			$('input[name="cidade2"]').val(data.cidade);
			$('input[name="estado2"]').val(data.estado);
		}).fail(function() {
			$('#loading').hide();
			$('input[name="cep2"]').val('');
			$('input[name="bairro2"]').val('');
			$('input[name="cidade2"]').val('');
			$('input[name="logradouro2"]').val('');
			$('input[name="estado2"]').val('');
			alert('CEP não encontrado. Informe outro.');
		});
	}
}
</script>

<script>
function updateVendedores(id) {
	let divvendedores = $('#'+id);
	let empresaid = $('#selectempresa_modal').val();
	divvendedores.load( "<?=$this->request->getAttribute("base") ?>/flystart/Filtros/vendedores?empresaid="+empresaid+"&vendedor=nulo");
}

$(document).ready(function(){updateVendedores('vendedores')})

</script>