<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cliente $cliente
 */
?>
<div class="card">
<?php if(!$isAjax){?>
<div class="card-header">
	<h3>Cliente <?=($cliente->clienteid)?> - <?=h($pessoa->nome)?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-address-book fa-2" aria-hidden="true"></i> Cadastrar Negociação', ['controller'=>'contato','action' => 'add', $cliente->clienteid],['class'=>'btn btn-success','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-address-book fa-2" aria-hidden="true"></i> Histórico de Processos', ['controller'=>'contato','action' => 'cliente', $cliente->clienteid],['class'=>'btn btn-success','escape'=>false]) ?>
		<!--<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i> Estatística', ['controller'=>'cliente','action' => 'estatisticas', $cliente->clienteid],['class'=>'btn btn-success','escape'=>false]) ?>-->
		
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $cliente->clienteid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?php 
			if(in_array($perfilid,[1,7]))
			echo $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $cliente->clienteid], ['confirm' => __('Deseja deletar # {0}?', $cliente->clienteid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
<?php }//fim if ?>
	<div class="row">
		<div class="col-md-6">
			<i class="fa fa-building"></i> <b><?=$this->Custom->get('empresa_crm','empresaid',$cliente->empresaid)->nomefantasia?></b>
			<br>
			<b>Vendedor Responsável: </b>
			<?php
				if($cliente->vendedorid){
					$vendedor = $this->Custom->get('vendedor','idvendedor',$cliente->vendedorid);
					echo $this->Custom->get('pessoa','pessoaid',$vendedor->pessoaid)->nome;
				}?>
		</div>
		<div class="col-md-6">
			<b>Origem:</b>
			<span class="badge badge-primary badge-pill"><?=$cliente->origemlead?></span>
			<br>
			<b>Tipo:</b>
			<span class="badge badge-primary badge-pill"><?=$cliente->tipocliente?></span>
		</div>
	</div>
	<br>
	<div class="media align-items-stretch" style="box-shadow: 0 2px 0px 0 rgba(0,0,0,0.2),0 6px 10px 0 rgba(0,0,0,0.19) !important; cursor:pointer"
	onclick="slideupdown3()">
		<div class="media-middle">
			&nbsp;&nbsp;<i class="fa fa-user"></i>
		</div>
		<div class="media-body">
		  <h5>&nbsp;&nbsp;Dados Pessoais</h5>
		</div>
		<div id="btntoggleup1" class="media-right media-middle" style="cursor:pointer" >
			<i class="fa fa-arrow-up"></i>
		</div>
		<div id="btntoggledown1" class="media-right media-middle" style="cursor:pointer;display:none" >
			<i class="fa fa-arrow-down"></i>
		</div>
		&nbsp;&nbsp;
	</div>
	<br>
	<div class="row" id="togglecontent1">
		<div class="col-md-6">
			<br>
			<b>Cód. no ERP:</b><br>
			<?=h($cliente->coderp)?>
			<br><br>
			<b>Nome/Nome Fantasia:</b><br>
			<?=h($pessoa->nome)?>
			<br><br>
			<b>Nome Social/Razão Social:</b><br>
			<?=$pessoa->razaosocial?>
			<br><br>
			<b>Qts de CNPJ(Unidades):</b><br>
			<?=$pessoa->dependentes?>
			<br><br>
			<b>CPF/ CNPJ:</b><br>
			<?=$pessoa->cpfcnpj?>
			<br><br>
			<b>Observação:</b><br>
			<?=nl2br($cliente->observacao)?>
			<br><br>
			<div class="media align-items-stretch" style="box-shadow: 0 2px 0px 0 rgba(0,0,0,0.2),0 6px 10px 0 rgba(0,0,0,0.19) !important;">
				<div class="media-middle">
					&nbsp;&nbsp;<i class="fa fa-phone"></i>
				</div>
				<div class="media-body">
				  <h5>&nbsp;&nbsp;Telefones (<?=count($telefones)?>)</h5>
				</div>
				<div id="btntoggleup2" class="media-right media-middle" style="cursor:pointer" onclick="$(this).hide();$('#btntoggledown2').show();$('#togglecontent2').slideUp();">
					<i class="fa fa-arrow-up"></i>
				</div>
				<div id="btntoggledown2" class="media-right media-middle" style="cursor:pointer;display:none" onclick="$(this).hide();$('#btntoggleup2').show();$('#togglecontent2').slideDown();">
					<i class="fa fa-arrow-down"></i>
				</div>
				&nbsp;&nbsp;
			</div>
			<br>
			<div class="row" id="togglecontent2">
				<div class="col-md-12" style="max-height:300px;overflow-y:auto">
					<?php if(count($telefones) == 0){echo "Nenhum telefone.";}?>
					<ul style="list-style: none;padding:0px">
					<?php
						$counter =0;
						$background = 'none';
						foreach($telefones as $item){
							$counter++;
							if($counter%2==0){$background = 'none';}else{$background = '#f1f1f1';}
							echo "<li style='background:$background;width:100%'>";
							echo  $item->tipotelefone." <br> ".$item->codigopais ." ".$item->ddd." ". $item->numero;
							echo "</li>";
						}
						
					?>
					</ul>
				</div>
			</div>
			<br>
			<!--<b>Cidade Nascimento:</b><br>
			< ?=$pessoa->cidade?>
			<br><br>
			<b>Estado Nascimento:</b><br>
			< ?=$pessoa->estado?>
			<br><br>
			<b>País Nascimento:</b><br>
			< ?=$pessoa->pais?> -->
			<br><br>
		</div>
		<div class="col-md-6">
			<!-- <b>Data de Nascimento:</b><br>
			< ?=$pessoa->datanascimento?>
			<br><br>
			<b>Sexo:</b><br>
			< ?=$pessoa->sexo?>
			<br><br> -->
			<br>
			<b>Email:</b><br>
			<?=$pessoa->email?>
			<br><br>
			<b>Cargo:</b><br>
			<?=$pessoa->cargo?>
			<br><br>
			<b>Segmento de Atuação:</b><br>
			<?=$pessoa->segmento?>
			<br><br>
			<b>Nome do Responsável:</b><br>
			<?=$pessoa->nomemae?>
			<br><br>
			<b>Telefone do Responsável:</b><br>
			<?=$pessoa->cpfmae?>
			<br><br>
			<b>Data de cadastro:</b><br>
			<?=h($pessoa->data_criacao)?>
		</div>
	</div>
	<br>
	<br>
	<div class="media align-items-stretch" style="box-shadow: 0 2px 0px 0 rgba(0,0,0,0.2),0 6px 10px 0 rgba(0,0,0,0.19) !important; cursor:pointer"
	onclick="slideupdown5()">
		<div class="media-middle">
			&nbsp;&nbsp;<i class="fa fa-map"></i>
		</div>
		<div class="media-body">
		  <h5>&nbsp;&nbsp;Endereços (<?=count($enderecos)?>)</h5>
		</div>
		<div id="btntoggleup3" class="media-right media-middle" style="cursor:pointer" >
			<i class="fa fa-arrow-up"></i>
		</div>
		<div id="btntoggledown3" class="media-right media-middle" style="cursor:pointer;display:none" >
			<i class="fa fa-arrow-down"></i>
		</div>
		&nbsp;&nbsp;
	</div>
	<br>
	<div id="togglecontent3">
		<?php foreach($enderecos as $item){ ?>
			<div class="row" >
				<div class="col-md-6">
					<?php if($item->logradouro){ ?>
					<a target="_blank" class="btn btn-primary btn-sm white"
					href="https://www.google.com/maps?saddr=My+Location&daddr=<?=$item->logradouro.", ".$item->numero?>. <?=$cliente->cep?>, <?=$cliente->cidade?>/<?=$cliente->estado?>">
						<i class="fa fa-map" aria-hidden="true"></i> 
						Abrir rota
					</a><br><br>
					<?php } ?>
					<b>Tipo Endereço:</b><br>
					<?=$item->tipoendereco?>
					<br><br>
					<b>CEP:</b><br>
					<?=$item->cep?>
					<br><br>
					<b>Logradouro:</b><br>
					<?=$item->logradouro?>
					<br><br>
					<b>Número:</b><br>
					<?=$item->numero?>
					<br><br>
					<b>Complemento:</b><br>
					<?=$item->logradouro?>
					<br><br>
				</div>
				<div class="col-md-6">
					<b>Bairro:</b><br>
					<?=$item->logradouro?>
					<br><br>
					<b>Cidade:</b><br>
					<?=$item->cidade?>
					<br><br>
					<b>Estado:</b><br>
					<?=$item->estado?>
					<br><br>
					<b>País:</b><br>
					<?=$item->pais?>
					<br><br>
					<b>Observação:</b><br>
					<span style="text-align:left">
					<?=$item->observacoes?>
					</span>
				</div>
			</div>
			<hr>
		<?php }//fim foreach ?>
	</div>
</div>
<script>
var slide3 = 1;
function slideupdown3(){
    if (slide3 == 1){
        slide3 = 0;
		$('#btntoggleup1').hide();$('#btntoggledown1').show();$('#togglecontent1').slideUp();
    } else {
        slide3 = 1;
		$('#btntoggledown1').hide();$('#btntoggleup1').show();$('#togglecontent1').slideDown();
    }
}
var slide4 = 1;
function slideupdown4(){
    if (slide4 == 1){
        slide4 = 0;
		$('#btntoggleup0').hide();$('#btntoggledown0').show();$('#togglecontent0').slideUp();    
	} else {
        slide4 = 1;
		$('#btntoggledown0').hide();$('#btntoggleup0').show();$('#togglecontent0').slideDown();    
    }
}
var slide5 = 1;
function slideupdown5(){
    if (slide5 == 1){
        slide5 = 0;
		$('#btntoggleup3').hide();$('#btntoggledown3').show();$('#togglecontent3').slideUp();    
	} else {
        slide5 = 1;
		$('#btntoggledown3').hide();$('#btntoggleup3').show();$('#togglecontent3').slideDown();    
    }
}

</script>
<?php if(!$isAjax){?>
</div>
<?php } ?>

