<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Compra[]|\Cake\Collection\CollectionInterface $compra
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Orçamentos') ?></h3>
	<!-- <div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div> -->
</div>
<div class="card-body">
    <table class="table table-responsive table-striped datatable" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th>Núm. Orçamento</th>
                <th>Data</th>
                <th>Cliente</th>
                <th>Total Pedido</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($compra as $item): ?>
            <tr style="cursor:pointer" onclick="window.open('<?=$this->request->getAttribute('base')?>/flystart/pedidovenda/orcamentoview/<?=$item->id?>')">
                <td><?= h($item->id) ?></td>
                <td><?= h($item->datacadastro) ?></td>

                <td><?php
                    if(strlen($item->idpessoa) > 0){
                        echo $this->Custom->get('pessoa','pessoaid',$item->idpessoa)->nome;
                    }
                ?></td>
                <td><?= $this->Custom->toMoney($item->totalliquido) ?></td>
                 <td><?php
                    if($item->status == 0){
                        echo '<span class="badge badge-warning">Pendente<span>';
                    } else if($item->status == 1){
                        echo '<span class="badge badge-success">Aprovado<span>';
                    } else{
                        echo '<span class="badge badge-danger">Cancelado<span>';
                    }
                ?></td>

            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

</div>
</div>

<script>
setTimeout(function() {
    $(".datatable").DataTable({
        "order": [[ 0, "desc" ]],
        responsive: false,
        retrieve: false,
        paging : true,
        scroll : false,
        searching: true,
        fixedHeader: {
          header: true,
          footer: false
        },
        language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            buttons: [
                {
                  extend: 'copy',
                  text: 'Copiar'
                },
                {
                  extend: 'print',
                  text: 'Imprimir',
                  messageTop: 'Relatório: ',
                },
                {
                  extend: 'excel',
                  text: 'Excel',
                  messageTop: 'Relatório:',
                },
                {
                  extend: 'pdf',
                  text: 'PDF',
                  messageTop: 'Relatório: ',
                }
            ],
            dom: 'Bfrtip'
    });
}, 500);
</script>
