<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cliente[]|\Cake\Collection\CollectionInterface $cliente
 */
?>
<div class="row">
	<div class="col-md-12">
		<div class="card">
            <div class="card-header">
                <h3>Clientes</h3>
            </div>
			<div class="card-body">
				<div class="row">
					<form method="GET" action="buscar" style="width:100%">
						<div class="input-group">
                            <input value="<?=$busca?>" name="busca" class="form-control" placeholder="Procure por nome ou código" type="text">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Buscar</button>
                            </div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<?php if(isset($_GET['busca'])){ ?>
<div class="card">
<div class="card-body">

    	Resultado da busca por: <b><?=$busca?></b><br>
		<b><?=count($resultadoarr)?></b> resultado(s) encontrado(s)
        <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0" style="width:100%">
            <tbody>
                <?php foreach ($resultadoarr as $cliente){ 
					$pessoa = $this->Custom->get('pessoa','pessoaid',$cliente->pessoaid);
				?>
                    <tr>
						<td>
                            <b><?=$cliente->clienteid?></b>
                            <?=$pessoa->nome?>
                            <br>
                            <span style="font-size:10px"><?=$cliente->origemlead?></span>
							<span style="font-size:10px"><?=$this->Custom->toDatetime($cliente->data_criacao)?></span>
                        </td>
						<td>
							<a target="_BLANK" href="view/<?=$cliente->clienteid?>" class="btn btn-primary">
								<i class="fa fa-eye"></i> ver
							</a>
						</td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
		<div class="paginator">
			<ul class="pagination">
				<?= $this->Paginator->first('<< ' . __('primeiro')) ?>
				<?= $this->Paginator->prev('< ' . __('anterior')) ?>
				<?= $this->Paginator->numbers() ?>
				<?= $this->Paginator->next(__('próximo') . ' >') ?>
				<?= $this->Paginator->last(__('último') . ' >>') ?>
			</ul>
			<p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
		</div>
</div>
</div>
<?php } ?>
