<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Contato[]|\Cake\Collection\CollectionInterface $contato
 */
?>
<div class="card">
<div class="card-header">
	<h3>Histórico de Processos</h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-address-book fa-2" aria-hidden="true"></i> Cadastrar Processo', ['controller'=>'contato','action' => 'add', $cliente->clienteid],['class'=>'btn btn-success','escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
	<b>Cliente:</b> <?=$pessoa->nome?><br>
	<b>Origem Lead:</b> <?=$cliente->origemlead?><br>
	<b>Tipo Cliente:</b> <?=$cliente->tipocliente?><br>
	<b>Data de Cadastro do Cliente:</b> <?=$cliente->data_criacao->format('d/m/Y H:i')?><br>
	<br>
    <table style="font-size:12px;text-align:center" class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
				<th scope="col">Processo</th>
				<th scope="col">Vendedor</th>
                <th scope="col">Data Processo</th>
				<th scope="col">Status Processo</th>
				<th scope="col">Grau Interesse</th>
				<th scope="col"></th>
				<th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($contato as $contato): 
				$cliente = $this->Custom->get('cliente','clienteid',$contato->clienteid);
			?>
            <tr>
				<td><?= $contato->contatoid ?></td>
				<td><?php 
					$sql = "select p.nome from contato c 
							inner join vendedor v on c.vendedorid = v.idvendedor
							inner join pessoa p on p.pessoaid = v.pessoaid
							where c.contatoidpai = ".$contato->contatoid." or contatoid = ".$contato->contatoid."
						order by contatoid desc 
						limit 1
					";
					$vendedorcontato = $this->Custom->query($sql);		
					echo (count($vendedorcontato)>0?$vendedorcontato[0]->nome:'');
					
				?></td>
				<td><?= $contato->data_criacao->format('d/m/Y H:i') ?></td>
				<td><?php
					$sql = "
						select statuscontato 
						from contato 
						where contatoidpai = ".$contato->contatoid." or contatoid = ".$contato->contatoid."
						order by contatoid desc 
						limit 1
					";
					$statuscontato = $this->Custom->query($sql);
					echo (count($statuscontato)>0?$statuscontato[0]->statuscontato:'');
					?></td>
				<td><?php
					$sql = "
						select grauinteresse 
						from contato 
						where contatoidpai = ".$contato->contatoid." or contatoid = ".$contato->contatoid."
						order by contatoid desc 
						limit 1
					";
					$grauinteresse = $this->Custom->query($sql);
					echo (count($grauinteresse)>0?$grauinteresse[0]->grauinteresse:'');
					?></td>
					<?php 
					$sql = "
						select vendedorid 
						from contato 
						where contatoidpai = ".$contato->contatoid." or contatoid = ".$contato->contatoid."
						order by contatoid desc 
						limit 1
					";
					$consulta = $this->Custom->query($sql);
					$ultimovendedorid = $consulta[0]->vendedorid;

					if (($perfilid == 5 && $ultimovendedorid == $vendedorid) || $perfilid != 5) { ?>
						<td>
					<a target="_BLANK" href="../../contato/view/<?php
						$id = $contato->contatoid;
						if($contato->contatoidpai != null){
							$id = $contato->contatoidpai;
						}
						echo $id;
						?>" class="btn btn-primary btn-sm">
						<i class="fa fa-eye fa-2"></i> ver
					</a>
				</td>
					<?php } ?>
                
				<td>
					<?php 
					if(in_array($perfilid,[1,7]))
					echo $this->Form->postLink('<i class="fa fa-trash fa-2" aria-hidden="true"></i>', ['action' => 'delete', $contato->contatoid], ['confirm' => __('Deseja deletar # {0}?', $contato->contatoid),'class'=>'btn btn-danger btn-sm', 'escape'=>false]) ?>
				</td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>&nbsp;&nbsp;
            <?= $this->Paginator->numbers() ?>&nbsp;&nbsp;
            <?= $this->Paginator->next(__('próximo') . ' >') ?>&nbsp;&nbsp;
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
<script>
	$('td').css('padding','2px');
</script>
