<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cliente $cliente
 */
?>
<div id="cliente-edit">
<div class="card">
<?php if(!$isAjax){?>
<div class="card-header">
		<h3>Editar Cadastro de: Id.: <?=$cliente->clienteid?> - Cliente: <?=$pessoa->nome?></h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-address-book fa-2" aria-hidden="true"></i> Cadastrar Contato', ['controller'=>'contato','action' => 'add', $cliente->clienteid],['class'=>'btn btn-success','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-address-book fa-2" aria-hidden="true"></i> Histórico de contatos', ['controller'=>'contato','action' => 'cliente', $cliente->clienteid],['class'=>'btn btn-success','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i>  Ver', ['action' => 'view', $cliente->clienteid], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?php
				if(in_array($perfilid,[1,7]))
				echo $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $cliente->clienteid], ['confirm' => __('Deseja deletar # {0}?', $cliente->clienteid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
		</div>
</div>
	<?php }//fim if ?>
<div class="card-body">
    <?= $this->Form->create($cliente,['id'=>'form-edit']) ?>
		<div class="row">
			<div class="col-md-6">
			<?php
				//administrador de sistema e secretaria de sistema
				if(in_array($perfilid,[1,7])){
					echo "<br>";
					$empresas = $this->Custom->getAllTableWhere('empresa_crm',[],['nomefantasia'=>'asc']);
					echo "<label>Empresa</label>";
					echo "<select name='empresaid' class='form-control'>";
						echo "<option value=''>.: Selecione uma opção :.</option>";
					foreach($empresas as $item){
						$selected = '';
						if($item->empresaid == $cliente->empresaid){
							$selected = 'selected';
						}
						echo "<option value='".$item->empresaid."' $selected>".$item->nomefantasia."</option>";
					}
					echo "</select>";
				}
			?>
			</div>
			<div class="col-md-6">
			<?php if(!$isAjax){

				echo $this->Form->button(__('Enviar'),['class'=>'btn btn-primary','style'=>'float:right']);
				 }
				echo "<br>";

				if($cliente->empresaid && !in_array($perfilid,[5])){
					$sql = "
						select
						v.vendedorid
						,p.nome
						from
						vendedor v
						inner join pessoa p on p.pessoaid = v.pessoaid
						where v.empresaid = ".$cliente->empresaid."
						order by p.nome
					";
					$vendedores = $this->Custom->query($sql);
					echo "<label>Vendedor Responsável</label>";
					echo "<select name='vendedorid' class='form-control'>";
						echo "<option value=''>.: Selecione uma opção :.</option>";
					foreach($vendedores as $item){
						$selected = '';
						if($item->vendedorid == $cliente->vendedorid){
							$selected = 'selected';
						}
						echo "<option value='".$item->vendedorid."' $selected>".$item->nome."</option>";
					}
					echo "</select>";

				}
			?>
			</div>
		</div>
		<br>
		<div class="media align-items-stretch" style="box-shadow: 0 2px 0px 0 rgba(0,0,0,0.2),0 6px 10px 0 rgba(0,0,0,0.19) !important;">
			<div class="media-middle">
				&nbsp;&nbsp;<i class="fa fa-user"></i>
			</div>
			<div class="media-body">
			  <h5>&nbsp;&nbsp;Dados Pessoais</h5>
			</div>
			<div id="btntoggleup1" class="media-right media-middle" style="cursor:pointer;display:none" onclick="$(this).hide();$('#btntoggledown1').show();$('#togglecontent1').slideUp();">
				<i class="fa fa-arrow-up"></i>
			</div>
			<div id="btntoggledown1" class="media-right media-middle" style="cursor:pointer" onclick="$(this).hide();$('#btntoggleup1').show();$('#togglecontent1').slideDown();">
				<i class="fa fa-arrow-down"></i>
			</div>
			&nbsp;&nbsp;
		</div>
		<br>
		<div class="row" id="togglecontent1">
		<div class="col-md-6">
			<?php
			echo $this->Form->control('coderp',['value'=>$cliente->coderp,'class'=>'form-control','label'=>'Cód. no ERP']);
			echo $this->Form->control('nome',['value'=>$pessoa->nome,'class'=>'form-control','label'=>'Nome/Nome Fantasia']);
			echo $this->Form->control('razaosocial',['value'=>$pessoa->razaosocial,'class'=>'form-control','label'=>'Nome Social/Razão Social']);
			echo $this->Form->control('cpfcnpj',['value'=>$pessoa->cpfcnpj,'class'=>'form-control','label'=>'CPF/CNPJ']);
			echo $this->Form->control('data_cliente', ['type'=>'text','class'=>'form-control maskdate','label'=>'Data em que se tornou cliente']);

			$tipocliente = $this->Custom->getAllTableWhere('tipocliente',[],['ordem'=>'asc']);
			echo "<label>Tipo Cliente</label>";
			echo "<select name='tipocliente' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($tipocliente as $item){
				$selected = '';
				if($item->nome == $cliente->tipocliente){
					$selected = 'selected';
				}
				echo "<option value='".$item->nome."' $selected>".$item->nome."</option>";
			}
			echo "</select>";


			$origemlead = $this->Custom->getAllTableWhere('origemlead',[],['ordem'=>'asc']);
			echo "<label>Origem Lead</label>";
			echo "<select name='origemlead' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($origemlead as $item){
				$selected = '';
				if($item->nome == $cliente->origemlead){
					$selected = 'selected';
				}
				echo "<option value='".$item->nome."' $selected>".$item->nome."</option>";
			}
			echo "</select>";

			$tipolead = $this->Custom->getAllTableWhere('tipolead',[],['ordem'=>'asc']);
			echo "<label>Tipo Lead</label>";
			echo "<select name='tipolead' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($tipolead as $item){
				$selected = '';
				if($item->nome == $cliente->tipolead){
					$selected = 'selected';
				}
				echo "<option value='".$item->nome."' $selected>".$item->nome."</option>";
			}
			echo "</select>";
			?>

            <label>Cliente Ativo</label>
			<select name='ativo' class='form-control'>
				<option value='1' <?php if($cliente->ativo ==  1){echo "selected";} ?>>Sim</option>
				<option value='0' <?php if($cliente->ativo === 0){echo "selected";} ?>>Não</option>
			</select>



			<label>Tipo Pessoa</label>
			<select name='tipopessoa' class='form-control'>
				<option value='FÍSICA'   <?php if($pessoa->tipopessoa == 'FÍSICA'){echo "selected";} ?>>Física</option>
				<option value='JURÍDICA' <?php if($pessoa->tipopessoa == 'JURÍDICA'){echo "selected";} ?>>Jurídica</option>
			</select>

			<!--<label>Sexo</label>
			<select name='sexo' class='form-control'>
				<option < ?php if($pessoa->sexo == 'Masculino'){echo "selected";} ?>>Masculino</option>
				<option < ?php if($pessoa->sexo == 'Feminino'){echo "selected";} ?>>Feminino</option>
				<option < ?php if($pessoa->sexo == 'Outro'){echo "selected";} ?>>Outro</option>
			</select>-->

		</div>
		<div class="col-md-6">

		<?php

			$segmento = $this->Custom->getAllTableWhere('segmento',[],['nome'=>'asc']);
				echo "<label>Segmento de Atuação</label>";
				echo "<select name='segmento' class='form-control'>";
					echo "<option value=''>.: Selecione uma opção :.</option>";
				foreach($segmento as $item){
					$selected = '';
					if($item->nome == $pessoa->segmento){
						$selected = 'selected';
					}
					echo "<option value='".$item->nome."' $selected>".$item->nome."</option>";
				}
				echo "</select>";

			echo $this->Form->control('Dtd. CNPJ (Unidades)',['value'=>$cliente->dependentes,'class'=>'form-control']);
			echo $this->Form->control('email',['value'=>$pessoa->email,'class'=>'form-control']);
            /*echo $this->Form->control('datanascimento', ['value'=>$pessoa->datanascimento,'class'=>'form-control maskdate','label'=>'Data de Nascimento']);
            echo $this->Form->control('cidade',['value'=>$pessoa->cidade,'class'=>'form-control','label'=>'Cidade de Nascimento']);
            echo $this->Form->control('estado',['value'=>$pessoa->estado,'class'=>'form-control','label'=>'Estado de Nascimento']);
            echo $this->Form->control('pais',['value'=>$pessoa->pais,'class'=>'form-control','label'=>'País de Nascimento']);*/
            echo $this->Form->control('cargo',['value'=>$pessoa->cargo,'class'=>'form-control']);
            echo $this->Form->control('nomemae',['value'=>$pessoa->nomemae,'class'=>'form-control','label'=>'Nome do Responsável']);
			echo $this->Form->control('cpfmae',['value'=>$pessoa->cpfmae,'class'=>'form-control','label'=>'Telefone do Responsável']);
			echo $this->Form->control('observacoes3',['value'=>$cliente->observacao,'maxlength'=> '500','type'=>'textarea','class'=>'form-control','label'=>'Observacoes']);
        ?>
		<br>
		<?php if(!$isAjax){?>
		<?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary','style'=>'float:right']) ?>
		<?php }//fim if ?>
		<?php if($isAjax){?>
		<?= $this->Form->button(__('Atualizar Cadastro'),['class'=>'btn btn-primary','style'=>'float:right']) ?>
		<?php }//fim if ?>
		</div>

	</div>
	<br>
	<div class="media align-items-stretch" style="box-shadow: 0 2px 0px 0 rgba(0,0,0,0.2),0 6px 10px 0 rgba(0,0,0,0.19) !important;">
		<div class="media-middle">
			&nbsp;&nbsp;<i class="fa fa-phone"></i>
		</div>
		<div class="media-body">
		  <h5>&nbsp;&nbsp;Telefones (<?=count($telefones)?>)</h5>
		</div>
		<div id="btntoggleup2" class="media-right media-middle" style="cursor:pointer;display:none" onclick="$(this).hide();$('#btntoggledown2').show();$('#togglecontent2').slideUp();">
			<i class="fa fa-arrow-up"></i>
		</div>
		<div id="btntoggledown2" class="media-right media-middle" style="cursor:pointer" onclick="$(this).hide();$('#btntoggleup2').show();$('#togglecontent2').slideDown();">
			<i class="fa fa-arrow-down"></i>
		</div>
		&nbsp;&nbsp;
	</div>
	<br>
	<div class="row" id="togglecontent2">
		<div class="col-md-12" style="max-height:300px;overflow-y:auto;text-align:right">
			<?php if(count($telefones) == 0){echo "Nenhum telefone.";}?>
			<ul style="list-style: none;">
			<?php
				$counter =0;
				$background = 'none';
				foreach($telefones as $item){
					$counter++;
					if($counter%2==0){$background = 'none';}else{$background = '#f1f1f1';}
					echo "<li style='background:$background;width:100%'>";
					echo  $item->tipotelefone." | ".$item->codigopais ." ".$item->ddd." ". $item->numero;
			?>
				<a href="../../telefone/delete/<?=$item->telefoneid?>" class="btn btn-danger btn-sm">
					<i class="fa fa-trash"></i> excluir
				</a>
				</li>
			<?php }//fim foreach ?>
			</ul>
			<a href="<?=$this->request->getAttribute("base")?>/adm/telefone/add/<?=$pessoa->pessoaid?>" class="btn btn-primary">
				<i class="fa fa-plus"></i> Adicionar telefone
			</a>
		</div>

	</div>
	<br>
	<div class="media align-items-stretch" style="box-shadow: 0 2px 0px 0 rgba(0,0,0,0.2),0 6px 10px 0 rgba(0,0,0,0.19) !important;">
		<div class="media-middle">
			&nbsp;&nbsp;<i class="fa fa-shopping-cart"></i>
		</div>
		<div class="media-body">
		  <h5>&nbsp;&nbsp;Endereços (<?=count($enderecos)?>)</h5>
		</div>
		<div id="btntoggleup3" class="media-right media-middle" style="cursor:pointer" onclick="$(this).hide();$('#btntoggledown3').show();$('#togglecontent3').slideUp();">
			<i class="fa fa-arrow-up"></i>
		</div>
		<div id="btntoggledown3" class="media-right media-middle" style="cursor:pointer;display:none" onclick="$(this).hide();$('#btntoggleup3').show();$('#togglecontent3').slideDown();">
			<i class="fa fa-arrow-down"></i>
		</div>
		&nbsp;&nbsp;
	</div>
	<br>
	<div id="togglecontent3" style="text-align:right">
		<?php if(count($enderecos)==0){echo "Nenhum endereço.";} ?>
		<?php foreach($enderecos as $item){ ?>
			<div class="row" >
				<div class="col-md-4">
                    <div class="row mb-1">
                        <div class="col-md-6 mb-2">
                            <a target="_blank" class="btn btn-primary white btn-sm"
                            href="https://www.google.com/maps?saddr=My+Location&daddr=<?=$item->logradouro.", ".$item->numero?>. <?=$cliente->cep?>, <?=$cliente->cidade?>/<?=$cliente->estado?>">
                                <i class="fa fa-map" aria-hidden="true"></i>
                                Abrir rota
                            </a>
                        </div>
                        <div class="col-md-6">
                            <a href="../../endereco/delete/<?=$item->enderecoid?>" class="btn btn-danger btn-sm">
                                <i class="fa fa-trash"></i> Excluir
                            </a>
                        </div>
                        <div class="col-md-6">
                            <a href="../../endereco/edit/<?=$item->enderecoid?>" class="btn btn-primary btn-sm">
                                <i class="fa fa-edit"></i> Alterar
                            </a>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
					<b>Tipo Endereço:</b><br>
					<?=$item->tipoendereco?>
					<br><br>
					<b>CEP:</b><br>
					<?=$item->cep?>
					<br><br>
					<b>Logradouro:</b><br>
					<?=$item->logradouro?>
					<br><br>
				</div>
				<div class="col-md-4">
					<b>Número:</b><br>
					<?=$item->numero?>
					<br><br>
					<b>Bairro:</b><br>
					<?=$item->logradouro?>
					<br><br>
					<b>Cidade:</b><br>
					<?=$item->cidade?>
					<br><br>
					<b>Complemento:</b><br>
					<?=$item->logradouro?>
					<br><br>
				</div>
				<div class="col-md-4">
					<b>Estado:</b><br>
					<?=$item->estado?>
					<br><br>
					<b>País:</b><br>
					<?=$item->pais?>
					<br><br>
					<b>Observação:</b><br>
					<?=$item->observacao?>
				</div>
			</div>
			<hr>
		<?php }//fim foreach ?>
		<br><br>
		<a href="<?=$this->request->getAttribute("base")?>/adm/endereco/add/<?=$pessoa->pessoaid?>" class="btn btn-primary">
			<i class="fa fa-plus"></i> Adicionar endereço
		</a>
	</div>
    <br><br>
    <?= $this->Form->end() ?>
</div>
</div>

</div>

<script>
$('label').css('padding-top','5px');
$(document).ready($('#togglecontent1').slideUp());
$(document).ready($('#togglecontent2').slideUp());
$('#form-edit').submit(function() {
	$('#loading').show();
	$('#cliente-edit').html("<b>Carregando...</b>");
    $.ajax({
        data: $(this).serialize(),
        type: $(this).attr('method'),
        url: $(this).attr('action'),
        success: function(response) {
			<?php if(!$isAjax) { ?> $('#cliente-edit').html(response); <?php } ?>
            $('[data-dismiss="modal"]').click();
        }
    }).done(function(){
		$('#loading').hide();
	});
    return false;
});
</script>
