
<?php
$date = new DateTime();
$session = $this->request->session();
$totalRegistros = count($query);
$usuario = $session->read('login.usuario')->nome;
?>
<div class="card">    
    <div class="card-header">
        <b>Relatório:</b>&nbsp Contas <?= $labels[$position].$textofinal ?><br>
        <b>Emissão:</b>&nbsp<?= Date('d/m/Y h:m:i')?><br>
        <b>Usuário:</b>&nbsp<?= $usuario?><br>
        <b>Período:</b>&nbsp<?=$this->Custom->toMes(Date('m')).' de '.Date('Y')?><br>
        <b>Total de Registros:</b>&nbsp<?=$totalRegistros?><br>
    </div>
    <div class="card-body">
		<?=$this->element('tabela_padrao', [
				'data' => $query,
				'nomeRelatorio' => 'Contas '.$labels[$position].$textofinal, 
				'usuario' => $usuario, 
				'sistema' => 'FlyStart - Financeiro', 
				'posicoes_soma' => [3,4], 
				'id' => 'relatorio_datatable', 
				'headers' => ['Franquia', 'Cliente/Fornecedor', 'Descrição', 'Valor (R$)', 'Pago (R$)', 'Status', 'Vencimento'], 
				'columns' => ['razaosocial', 'nome', 'descricao', 'totalliquido', 'baixa', 'status', 'data_vencimento'], 
				'format' => ['','','','toFloat','toFloat','','formatData'], 
				'align' => ['','','','text-right','text-right','',''], 
				'pageLength' => 25, 
				'table_title' => '', 
                'onclick_funcao' => 'editconta',
                'onclick_parametro' => 'contaid',
                'mouse_over'=>true,
				'export' => true,
				'pdf_rightalign'=>[3,4]
			]);
		?>
    </div>
</div>
<script>
    function editconta(id){
        $('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
        $('#modal').modal('show').find('.modal-body').load('<?=$this->request->getAttribute('base').'/flystart/financeiro/edit/?id='?>'+id,function(responseText, textStatus, req){
            if (textStatus == "error") {
                alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
                $('[data-dismiss="modal"]').click();
            }
        });
        $('#loading').hide();

        $('button[data-dismiss="modal"]').on('click', function(e){
            $('.modal-body').html("");
        });
    }

</script>