<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cliente[]|\Cake\Collection\CollectionInterface $cliente
 */
?>
<div class="row">
	<div class="col-md-12">
		<div class="card">
            <div class="card-header">
                <h3>Produtos</h3>
            </div>
			<div class="card-body">
				<div class="row">
					<form method="GET" action="buscar" style="width:100%">
						<div class="input-group">
                            <input value="<?=$busca?>" name="busca" class="form-control" placeholder="Procure por nome ou código" type="text">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Buscar</button>
                            </div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<?php if(isset($_GET['busca'])){ ?>
<div class="card">
	<div class="card-body">
		Resultado da busca por: <b><?=$busca?></b>
		<br> mostrando <b><?=count($resultadoarr)?></b> registros
		<table id="tableproduto" style=" width: 100% !important" class="table tableproduto table-responsive table-striped " cellpadding="0" cellspacing="0">
				<thead>
					<th></th>
					<th></th>
					
				</thead>
				<tbody>
					<?php foreach ($resultadoarr as $produto){ ?>
						<tr style="cursor:pointer" onclick="window.location.href='<?= $this->request->getAttribute('base')?>/flystart/produto_crm/<?=$produto->idproduto?>'" 
						idproduto="<?=$produto->idproduto?>" 
						produto="<?=$produto->produto?>"
						grupo="<?=$produto->grupo?>"
						fabricante="<?=$produto->fabricante?>"
						valor="<?=$this->Custom->toFloat($produto->precovenda)?>"
						>
						<td>
							<b><?=$produto->idproduto?></b>
							<?=$produto->produto?>
							<br>
							<span style="font-size:10px">Grupo: <?=$produto->grupo?></span>
							<br>
							<span style="font-size:10px">Fabricante: <?=$produto->fabricante?></span>
						</td>
						<td>
							<span style="font-size:10px">Estoque: <?=$this->Custom->toNumber($produto->quantidade)?> <?=$produto->unidade?></span>
						</td>
						</tr>		
					<?php }?>
				</tbody>
			</table>
		
	</div>
</div>
<?php } ?>

<script>
	$('table td').css('padding','5px');
	$('table th').css('padding','18px');
	
	
	
	var datatable2 = $("#tableproduto").DataTable({
		responsive: false,
		retrieve: false,
		paging : false,
		scroll : true,
		fixedHeader: {
		  header: true,
		  footer: false
		},
		language: {
			url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
			decimal: ",",
			thousands: "."
		},
		dom: 'Bfrtip',
		buttons: []  
	});
	

	
</script>