<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Empresa[]|\Cake\Collection\CollectionInterface $empresa
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Empresa') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nome Fantasia</th>
                <th>Razão Social</th>
                <th>Ativo</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($empresas as $empresa): ?>
            <tr style="cursor:pointer" onclick="window.location.href='empresa/view/<?=$empresa->empresaid?>'">
                <td><?= $this->Number->format($empresa->empresaid) ?></td>
                <td><?= h($empresa->nomefantasia) ?></td>
                <td><?= h($empresa->razaosocial) ?></td>
                <td><?= $this->Custom->toSimNao($empresa->ativo) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
