<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Endereco $endereco
 */
?>
<div class="card">
<div class="card-header">
		<h3>Cadastrar Endereço</h3>
		<div class="float-right">
			<?php if($usuario != null){?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-user" aria-hidden="true"></i> Ir para usuário', ['controller'=>'usuario','action' => 'edit',$usuario->usuarioid], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?php } ?>
			<?php if($cliente != null){?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-user" aria-hidden="true"></i> Ir para cliente', ['controller'=>'cliente','action' => 'edit',$cliente->clienteid], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?php } ?>
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($endereco) ?>
        <div class="media align-items-stretch bg-gradient-x-primary white">
			<div class="p-1 media-middle">
				<i class="fa fa-map font-large-1 white"></i>
			</div>
			<div class="media-body p-1">
			  <h5>Endereço</h5>
			</div>
		</div>
		<br>
		<div>
			<div class="row" >
				<div class="col-md-12">
					<b>Pessoa: </b><?=$pessoa->nome?>
					<br><br>
				</div>
			</div>
			<div class="row" >
				<div class="col-md-6">
				<?php
					$tipoendereco = $this->Custom->getAllTableWhere('tipoendereco',[],['nome'=>'asc']);
					echo "<label>Tipo Endereco</label>";
					echo "<select name='tipoendereco1' class='form-control'>";
						echo "<option value=''>.: Selecione uma opção :.</option>";
					foreach($tipoendereco as $item){
						echo "<option value='".$item->nome."'>".$item->nome."</option>";
					}
					echo "</select>";
					
					echo $this->Form->control('cep1',['label'=>'CEP','class'=>'form-control maskcep', 'placeholder'=>'Informe o CEP para carregar o endereço','onkeyup'=>'getEnderecoCorreios1(this)', 'autocomplete'=>'off']);
					echo $this->Form->control('logradouro1',['class'=>'form-control','label'=>'Logradouro']);
					echo $this->Form->control('cidade1',['class'=>'form-control','label'=>'Cidade']);
					echo $this->Form->control('estado1',['class'=>'form-control','label'=>'Estado']);
					echo $this->Form->control('pais1',['value'=>'Brasil','class'=>'form-control','label'=>'País']);
				?>
				</div>
				<div class="col-md-6">
				<?php
					echo $this->Form->control('bairro1',['class'=>'form-control','label'=>'Bairro']);
					echo $this->Form->control('numero1',['class'=>'form-control','label'=>'Número']);
					echo $this->Form->control('complemento1',['class'=>'form-control','label'=>'Complemento']);
					echo $this->Form->control('observacoes1',['type'=>'textarea','class'=>'form-control','label'=>'Observação']);
					echo $this->Form->control('latlong1',['class'=>'form-control','label'=>'Latitude/Longitude']);
				?>
				</div>
				<br>
				<button type="button" onclick="$('#endereco2').show();$(this).hide()" class="btn btn-primary"><i class="fa fa-plus"></i> Cadastrar outro endereço</button>
			</div>
			<hr>
			<div style="display:none" id="endereco2" class="row">
				<div class="col-md-6">
					<?php
						$tipoendereco = $this->Custom->getAllTableWhere('tipoendereco',[],['nome'=>'asc']);
						echo "<label>Tipo Endereco</label>";
						echo "<select name='tipoendereco2' class='form-control'>";
							echo "<option value=''>.: Selecione uma opção :.</option>";
						foreach($tipoendereco as $item){
							echo "<option value='".$item->nome."'>".$item->nome."</option>";
						}
						echo "</select>";
						
						echo $this->Form->control('cep2',['label'=>'CEP','class'=>'form-control maskcep', 'placeholder'=>'Informe o CEP para carregar o endereço','onkeyup'=>'getEnderecoCorreios2(this)', 'autocomplete'=>'off']);
						echo $this->Form->control('logradouro2',['class'=>'form-control','label'=>'Logradouro']);
						echo $this->Form->control('cidade2',['class'=>'form-control','label'=>'Cidade']);
						echo $this->Form->control('estado2',['class'=>'form-control','label'=>'Estado']);
						echo $this->Form->control('pais2',['value'=>'Brasil','class'=>'form-control','label'=>'País']);
					?>
					</div>
					<div class="col-md-6">
					<?php
						echo $this->Form->control('bairro2',['class'=>'form-control','label'=>'Bairro']);
						echo $this->Form->control('numero2',['class'=>'form-control','label'=>'Número']);
						echo $this->Form->control('complemento2',['class'=>'form-control','label'=>'Complemento']);
						echo $this->Form->control('observacoes2',['type'=>'textarea','class'=>'form-control','label'=>'Observação']);
						echo $this->Form->control('latlong2',['class'=>'form-control','label'=>'Latitude/Longitude']);
					?>
					</div>
			</div>
		</div>
		<br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>

<script>
function getEnderecoCorreios1(el){
	if(el.value.replace('-','').length >= 8){
		$('#loading').show();
		$.getJSON( window.location.protocol+"//api.postmon.com.br/v1/cep/"+el.value.replace('-',''), function( data ) {
			$('#loading').hide();
			if(data.bairro){
				$('input[name="bairro1"]').val(data.bairro);
			}else{
				$('input[name="bairro1"]').val("Sem bairro");
			}
			if(data.logradouro){
				$('input[name="logradouro1"]').val(data.logradouro);
			}else{
				$('input[name="logradouro1"]').val("Sem logradouro");
			}
			
			$('input[name="cidade1"]').val(data.cidade);
			$('input[name="estado1"]').val(data.estado);
		}).fail(function() {
			$('#loading').hide();
			$('input[name="cep1"]').val('');
			$('input[name="bairro1"]').val('');
			$('input[name="cidade1"]').val('');
			$('input[name="logradouro1"]').val('');
			$('input[name="estado1"]').val('');
			alert('CEP não encontrado. Informe outro.');
		});
	}
}

function getEnderecoCorreios2(el){
	if(el.value.replace('-','').length >= 8){
		$('#loading').show();
		$.getJSON( window.location.protocol+"//api.postmon.com.br/v1/cep/"+el.value.replace('-',''), function( data ) {
			$('#loading').hide();
			if(data.bairro){
				$('input[name="bairro2"]').val(data.bairro);
			}else{
				$('input[name="bairro2"]').val("Sem bairro");
			}
			if(data.logradouro){
				$('input[name="logradouro2"]').val(data.logradouro);
			}else{
				$('input[name="logradouro2"]').val("Sem logradouro");
			}
			
			$('input[name="cidade2"]').val(data.cidade);
			$('input[name="estado2"]').val(data.estado);
		}).fail(function() {
			$('#loading').hide();
			$('input[name="cep2"]').val('');
			$('input[name="bairro2"]').val('');
			$('input[name="cidade2"]').val('');
			$('input[name="logradouro2"]').val('');
			$('input[name="estado2"]').val('');
			alert('CEP não encontrado. Informe outro.');
		});
	}
}
</script>
