<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Endereco $endereco
 */
?>
<div class="card">
<div class="card-header">
		<div class="float-right">
			<?php if($usuario != null){?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-user" aria-hidden="true"></i> Ir para usuário', ['controller'=>'usuario','action' => 'edit',$usuario->usuarioid], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?php } ?>
			<?php if($cliente != null){?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-user" aria-hidden="true"></i> Ir para cliente', ['controller'=>'cliente','action' => 'edit',$cliente->clienteid], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?php } ?>
			<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $endereco->enderecoid], ['confirm' => __('Deseja deletar # {0}?', $endereco->enderecoid),'class'=>'btn btn-danger', 'escape'=>false]) ?>
		</div>
</div>
	
<div class="card-body">
	<div class="media align-items-stretch bg-gradient-x-primary white">
		<div class="p-1 media-middle">
			<i class="fa fa-map font-large-1 white"></i>
		</div>
		<div class="media-body p-1">
		  <h5>Editar Endereço</h5>
		</div>
	</div>
	<br>
	<div class="row" >
		<div class="col-md-12">
			<b>Pessoa: </b><?=$pessoa->nome?>
			<br><br>
		</div>
	</div>
    <?= $this->Form->create($endereco) ?>
    <div class="row" >
		<div class="col-md-6">
		<?php
			$tipoendereco = $this->Custom->getAllTableWhere('tipoendereco',[],['nome'=>'asc']);
			echo "<label>Tipo Endereco</label>";
			echo "<select name='tipoendereco' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($tipoendereco as $item){
				$selected = '';
				if($item->nome == $endereco->tipoendereco){
					$selected = 'selected';
				}
				echo "<option value='".$item->nome."' $selected>".$item->nome."</option>";
			}
			echo "</select>";
			
			echo $this->Form->control('cep',['label'=>'CEP','class'=>'form-control maskcep', 'placeholder'=>'Informe o CEP para carregar o endereço','onkeyup'=>'getEnderecoCorreios(this)', 'autocomplete'=>'off']);
			echo $this->Form->control('logradouro',['class'=>'form-control','label'=>'Logradouro']);
			echo $this->Form->control('cidade',['class'=>'form-control','label'=>'Cidade']);
			echo $this->Form->control('estado',['class'=>'form-control','label'=>'Estado']);
			echo $this->Form->control('pais',['class'=>'form-control','label'=>'País']);
		?>
		</div>
		<div class="col-md-6">
		<?php
			echo $this->Form->control('bairro',['class'=>'form-control','label'=>'Bairro']);
			echo $this->Form->control('numero',['class'=>'form-control','label'=>'Número']);
			echo $this->Form->control('complemento',['class'=>'form-control','label'=>'Complemento']);
			echo $this->Form->control('observacoes',['type'=>'textarea','class'=>'form-control','label'=>'Observação']);
			echo $this->Form->control('latlong',['class'=>'form-control','label'=>'Latitude/Longitude']);
		?>
		</div>
    &nbsp;&nbsp;&nbsp;&nbsp;<?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
	</div>
</div>
</div>

<script>
function getEnderecoCorreios(el){
	if(el.value.replace('-','').length >= 8){
		$('#loading').show();
		$.getJSON( window.location.protocol+"//api.postmon.com.br/v1/cep/"+el.value.replace('-',''), function( data ) {
			$('#loading').hide();
			if(data.bairro){
				$('input[name="bairro"]').val(data.bairro);
			}else{
				$('input[name="bairro"]').val("Sem bairro");
			}
			if(data.logradouro){
				$('input[name="logradouro"]').val(data.logradouro);
			}else{
				$('input[name="logradouro"]').val("Sem logradouro");
			}
			
			$('input[name="cidade"]').val(data.cidade);
			$('input[name="estado"]').val(data.estado);
		}).fail(function() {
			$('#loading').hide();
			$('input[name="cep"]').val('');
			$('input[name="bairro"]').val('');
			$('input[name="cidade"]').val('');
			$('input[name="logradouro"]').val('');
			$('input[name="estado"]').val('');
			alert('CEP não encontrado. Informe outro.');
		});
	}
}
</script>
