<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Endereco[]|\Cake\Collection\CollectionInterface $endereco
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Endereco') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('enderecoid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('pessoaid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('empresaid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('logradouro') ?></th>
                <th scope="col"><?= $this->Paginator->sort('cidade') ?></th>
                <th scope="col"><?= $this->Paginator->sort('estado') ?></th>
                <th scope="col"><?= $this->Paginator->sort('pais') ?></th>
                <th scope="col"><?= $this->Paginator->sort('bairro') ?></th>
                <th scope="col"><?= $this->Paginator->sort('codibge') ?></th>
                <th scope="col"><?= $this->Paginator->sort('numero') ?></th>
                <th scope="col"><?= $this->Paginator->sort('complemento') ?></th>
                <th scope="col"><?= $this->Paginator->sort('tipoendereco') ?></th>
                <th scope="col"><?= $this->Paginator->sort('cep') ?></th>
                <th scope="col"><?= $this->Paginator->sort('observacoes') ?></th>
                <th scope="col"><?= $this->Paginator->sort('latlong') ?></th>
                <th scope="col"><?= $this->Paginator->sort('pessoaidcadastro') ?></th>
                <th scope="col"><?= $this->Paginator->sort('data_criacao') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($endereco as $endereco): ?>
            <tr style="cursor:pointer" onclick="window.location.href='endereco/view/<?=$endereco->enderecoid?>'">
                <td><?= $this->Number->format($endereco->enderecoid) ?></td>
                <td><?= $this->Number->format($endereco->pessoaid) ?></td>
                <td><?= $this->Number->format($endereco->empresaid) ?></td>
                <td><?= h($endereco->logradouro) ?></td>
                <td><?= h($endereco->cidade) ?></td>
                <td><?= h($endereco->estado) ?></td>
                <td><?= h($endereco->pais) ?></td>
                <td><?= h($endereco->bairro) ?></td>
                <td><?= h($endereco->codibge) ?></td>
                <td><?= h($endereco->numero) ?></td>
                <td><?= h($endereco->complemento) ?></td>
                <td><?= h($endereco->tipoendereco) ?></td>
                <td><?= h($endereco->cep) ?></td>
                <td><?= h($endereco->observacoes) ?></td>
                <td><?= h($endereco->latlong) ?></td>
                <td><?= $this->Number->format($endereco->pessoaidcadastro) ?></td>
                <td><?= h($endereco->data_criacao) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
