<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Endereco $endereco
 */
?>
<div class="card">
<div class="card-header">
	<h3>Endereco <?= h($endereco->enderecoid) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $endereco->enderecoid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $endereco->enderecoid], ['confirm' => __('Deseja deletar # {0}?', $endereco->enderecoid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Logradouro') ?></th>
            <td><?= h($endereco->logradouro) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Cidade') ?></th>
            <td><?= h($endereco->cidade) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Estado') ?></th>
            <td><?= h($endereco->estado) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pais') ?></th>
            <td><?= h($endereco->pais) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Bairro') ?></th>
            <td><?= h($endereco->bairro) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Codibge') ?></th>
            <td><?= h($endereco->codibge) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Numero') ?></th>
            <td><?= h($endereco->numero) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Complemento') ?></th>
            <td><?= h($endereco->complemento) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Tipoendereco') ?></th>
            <td><?= h($endereco->tipoendereco) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Cep') ?></th>
            <td><?= h($endereco->cep) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Observacoes') ?></th>
            <td><?= h($endereco->observacoes) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Latlong') ?></th>
            <td><?= h($endereco->latlong) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Enderecoid') ?></th>
            <td><?= $this->Number->format($endereco->enderecoid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pessoaid') ?></th>
            <td><?= $this->Number->format($endereco->pessoaid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Empresaid') ?></th>
            <td><?= $this->Number->format($endereco->empresaid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pessoaidcadastro') ?></th>
            <td><?= $this->Number->format($endereco->pessoaidcadastro) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criacao') ?></th>
            <td><?= h($endereco->data_criacao) ?></td>
        </tr>
    </table>
</div>
</div>
