<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Funil[]|\Cake\Collection\CollectionInterface $funil
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Funil') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('idfunil', 'Cod') ?></th>
                <th scope="col"><?= $this->Paginator->sort('descricao', 'Descrição') ?></th>
                <th scope="col"><?= $this->Paginator->sort('ativo', 'Ativo') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($funil as $funil): ?>
            <tr style="cursor:pointer" onclick="window.location.href='./view/<?=$funil->idfunil?>'">
                <td><?= $this->Number->format($funil->idfunil) ?></td>
                <td><?= h($funil->descricao) ?></td>
                <td><?= $this->Custom->toSimNao($funil->ativo) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
