<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Modulousuario[]|\Cake\Collection\CollectionInterface $modulousuario
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Modulousuario') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('modulousuarioid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('moduloid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('usuarioid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('data_criacao') ?></th>
                <th scope="col"><?= $this->Paginator->sort('pessoaidcadastro') ?></th>
                <th scope="col"><?= $this->Paginator->sort('empresaid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('ativo') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($modulousuario as $modulousuario): ?>
            <tr style="cursor:pointer" onclick="window.location.href='modulousuario/view/<?=$modulousuario->modulousuarioid?>'">
                <td><?= $this->Number->format($modulousuario->modulousuarioid) ?></td>
                <td><?= $this->Number->format($modulousuario->moduloid) ?></td>
                <td><?= $this->Number->format($modulousuario->usuarioid) ?></td>
                <td><?= h($modulousuario->data_criacao) ?></td>
                <td><?= $this->Number->format($modulousuario->pessoaidcadastro) ?></td>
                <td><?= $this->Number->format($modulousuario->empresaid) ?></td>
                <td><?= $this->Number->format($modulousuario->ativo) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
