<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Produto $produto
 */
?>
<div class="card">
<div class="card-header">
		<h3>Cadastro de Produto/Serviço</h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($produto) ?>
		<div class="row">
		<div class="col-md-6">
        <?php
            echo $this->Form->control('nome',['class'=>'form-control']);
            echo $this->Form->control('descricao',['class'=>'form-control','label'=>'Descrição']);
            
			echo "<label>Ativo</label>";
			echo "<select name='ativo' class='form-control'>";
				echo "<option value='1'>Sim</option>";
				echo "<option value='0'>Não</option>";
			echo "</select>";
			?>
			
			<label>Tempo</label>
			<div class="input-group">
				<input type="text" class="form-control masknumber" placeholder="Horas Mínima" name="idade_min">
				<input type="text" class="form-control masknumber" placeholder="Horas Máxima" name="idade_max">
			</div>

			<?php
			
			$grupoproduto = $this->Custom->getAllTableWhere('grupoproduto',[],['nome'=>'asc']);
			echo "<label>Grupo</label>";
			echo "<select name='grupoid' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($grupoproduto as $item){
				echo "<option value='".$item->grupoprodutoid."'>".$item->nome."</option>";
			}
			echo "</select>";
			
			$subgrupoproduto = $this->Custom->getAllTableWhere('subgrupoproduto',[],['nome'=>'asc']);
			echo "<label>Subgrupo</label>";
			echo "<select name='subgrupoid' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($subgrupoproduto as $item){
				echo "<option value='".$item->subgrupoprodutoid."'>".$item->nome."</option>";
			}
			echo "</select>";

			
			/* Campos não utilizados
			$operadora = $this->Custom->getAllTableWhere('operadora',[],['nome'=>'asc']);
			echo "<label>Operadora</label>";
			echo "<select name='operadora' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($operadora as $item){
				echo "<option value='".$item->nome."'>".$item->nome."</option>";
			}
			echo "</select>";
			*/
		?>
		</div>
		<div class="col-md-6">
        <?php
			
			echo $this->Form->control('fabricante',['class'=>'form-control','label'=>'Fabricante']);
			
			echo $this->Form->control('unidade',['class'=>'form-control','label'=>'Unidade']);

			echo $this->Form->control('sdofisico',['class'=>'form-control','label'=>'Saldo Físico']);

            echo $this->Form->control('valor',['class'=>'form-control maskmoney','label'=>'Valor (R$)']);
			
            echo $this->Form->control('observacoes',['type'=>'textarea','class'=>'form-control','label'=>'Observações']);
			
			/* Campos não utilizados
			$tipocontratacao = $this->Custom->getAllTableWhere('tipocontratacao',[],['nome'=>'asc']);
			echo "<label>Tipo Contratação</label>";
			echo "<select name='tipocontratacao' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($tipocontratacao as $item){
				echo "<option value='".$item->nome."'>".$item->nome."</option>";
			}
			echo "</select>";
			
			$tipoacomodacao = $this->Custom->getAllTableWhere('tipoacomodacao',[],['nome'=>'asc']);
			echo "<label>Tipo Acomodação</label>";
			echo "<select name='tipoacomodacao' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
			foreach($tipoacomodacao as $item){
				echo "<option value='".$item->nome."'>".$item->nome."</option>";
			}
			echo "</select>";
			
			
			echo "<label>Abrangência</label>";
			echo $this->Form->control('abrangencia',['class'=>'form-control','label'=>'Abrangência']);
			*/
        ?>
		<br>
		<?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary','id'=>'btn']) ?>
		</div>
		</div>
    <br><br>
    
    <?= $this->Form->end() ?>
</div>
</div>

<script>
$( "form" ).submit(function() {
  $("#btn").attr('disabled','disabled');
});
</script>