<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Produto $produto
 */
?>
<div class="card">
<div class="card-header">
		<h3>Editar Produto/Serviço id. <?=$produto->produtoid?></h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i>  Ver', ['action' => 'view', $produto->produtoid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
			<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $produto->produtoid], ['confirm' => __('Deseja deletar # {0}?', $produto->produtoid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($produto) ?>
		<div class="row">
			<div class="col-md-6">
			<?php
				echo $this->Form->control('nome',['class'=>'form-control']);
				echo $this->Form->control('descricao',['class'=>'form-control','label'=>'Descrição']);
			?>
				<label>Ativo</label>
				<select name='ativo' class='form-control'>
					<option value='1' <?php if($produto->ativo ==  1){echo "selected";} ?>>Sim</option>
					<option value='0' <?php if($produto->ativo === 0){echo "selected";} ?>>Não</option>
				</select>
				
				<label>Tempo</label>
				<div class="input-group">
					<input type="text" class="form-control masknumber" placeholder="Horas Mínima" name="idade_min" value="<?=$produto->idade_min?>">
					<input type="text" class="form-control masknumber" placeholder="Horas Máxima" name="idade_max" value="<?=$produto->idade_max?>">
				</div>
			<?php				
				$grupoproduto = $this->Custom->getAllTableWhere('grupoproduto',[],['nome'=>'asc']);
				echo "<label>Grupo</label>";
				echo "<select name='grupoid' class='form-control'>";
					echo "<option value=''>.: Selecione uma opção :.</option>";
				foreach($grupoproduto as $item){
					$selected = "";
					if($produto->grupo == $item->nome){$selected = "selected";}
					echo "<option value='".$item->grupoprodutoid."' $selected>".$item->nome."</option>";
				}
				echo "</select>";
				
				$subgrupoproduto = $this->Custom->getAllTableWhere('subgrupoproduto',[],['nome'=>'asc']);
				echo "<label>Subgrupo</label>";
				echo "<select name='subgrupoid' class='form-control'>";
					echo "<option value=''>.: Selecione uma opção :.</option>";
				foreach($subgrupoproduto as $item){
					$selected = "";
					if($produto->subgrupo == $item->nome){$selected = "selected";}
					echo "<option value='".$item->subgrupoprodutoid."' $selected>".$item->nome."</option>";
				}
				echo "</select>";
				/*
				$operadora = $this->Custom->getAllTableWhere('operadora',[],['nome'=>'asc']);
				echo "<label>Operadora</label>";
				echo "<select name='operadora' class='form-control'>";
					echo "<option value=''>.: Selecione uma opção :.</option>";
				foreach($operadora as $item){
					$selected = "";
					if($produto->operadora == $item->nome){$selected = "selected";}
					echo "<option value='".$item->nome."' $selected>".$item->nome."</option>";
				}
				echo "</select>";
				*/
			?>
			</div>
			<div class="col-md-6">
			<?php
				echo $this->Form->control('fabricante',['class'=>'form-control','label'=>'Fabricante']);
				
				echo $this->Form->control('unidade',['class'=>'form-control','label'=>'Unidade']);

				echo $this->Form->control('sdofisico',['class'=>'form-control','label'=>'Saldo Físico']);

				echo $this->Form->control('valor',['class'=>'form-control maskmoney']);
				
				echo $this->Form->control('observacoes',['type'=>'textarea','class'=>'form-control','label'=>'Observações']);
				/*
				$tipocontratacao = $this->Custom->getAllTableWhere('tipocontratacao',[],['nome'=>'asc']);
				echo "<label>Tipo Contratação</label>";
				echo "<select name='tipocontratacao' class='form-control'>";
					echo "<option value=''>.: Selecione uma opção :.</option>";
				foreach($tipocontratacao as $item){
					$selected = "";
					if($produto->tipocontratacao == $item->nome){$selected = "selected";}
					echo "<option value='".$item->nome."' $selected>".$item->nome."</option>";
				}
				echo "</select>";
				
				$tipoacomodacao = $this->Custom->getAllTableWhere('tipoacomodacao',[],['nome'=>'asc']);
				echo "<label>Tipo Acomodação</label>";
				echo "<select name='tipoacomodacao' class='form-control'>";
				echo "<option value=''>.: Selecione uma opção :.</option>";
				foreach($tipoacomodacao as $item){
					$selected = "";
					if($produto->tipoacomodacao == $item->nome){$selected = "selected";}
					echo "<option value='".$item->nome."' $selected>".$item->nome."</option>";
				}
				echo "</select>";
				*/
			?>
			<!--
				<label>Coparticipação</label>
				< ?=$this->Form->control('abrangencia',['class'=>'form-control','label'=>'Abrangência'])?>
			-->
			<br>
			<?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary','id'=>'btn']) ?>
			</div>
		</div>
    <?= $this->Form->end() ?>
</div>
</div>

<script>
$( "form" ).submit(function() {
  $("#btn").attr('disabled','disabled');
});
</script>