<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Produto $produto
 */
?>
<div class="card">
<div class="card-header">
	<h3>Produto/Serviço - Id. <?= h($produto->produtoid) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $produto->produtoid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $produto->produtoid], ['confirm' => __('Deseja deletar # {0}?', $produto->produtoid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Nome') ?></th>
            <td><?= h($produto->nome) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Descrição') ?></th>
            <td><?= h($produto->descricao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Valor') ?></th>
            <td><?= $this->Custom->toMoney($produto->valor) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Observações') ?></th>
            <td><?= h($produto->observacoes) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Grupo') ?></th>
            <td><?= h($produto->grupo) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('SubGrupo') ?></th>
            <td><?= h($produto->subgrupo) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Saldo Físico') ?></th>
            <td><?= h($produto->sdofisico) ?></td>
        </tr>
		<!-- 
        <tr>
            <th scope="row">< ?= __('Tipo Contratação') ?></th>
            <td>< ?= h($produto->tipocontratacao) ?></td>
        </tr>
        <tr>
            <th scope="row">< ?= __('Tipo Acomodação') ?></th>
            <td>< ?= h($produto->tipoacomodacao) ?></td>
        </tr>
        <tr>
            <th scope="row">< ?= __('Abrangência') ?></th>
            <td>< ?= $produto->abrangencia ?></td>
        </tr>
		-->
        <tr>
            <th scope="row"><?= __('Ativo') ?></th>
            <td><?= $this->Custom->toSimNao($produto->ativo) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Faixa de Tempo') ?></th>
            <td><?=$produto->idade_min." - ".$produto->idade_max?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Grupo') ?></th>
			<td><?=$produto->grupo?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Subgrupo') ?></th>
			<td><?=$produto->subgrupo?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Operadora') ?></th>
			<td><?=$produto->operadora?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criação') ?></th>
            <td><?= h($produto->data_criacao) ?></td>
        </tr>
    </table>
</div>
</div>
