<?php
  $this->layout = false;
  
  $date = new DateTime();
  $dataHora = $date->format('d/m/Y H:i:s');
  $dataTraco = $date->format('d-m-Y');
  $dataBarra = $date->format('d/m/Y');
  $session = $this->request->session();
  $totalRegistros = count($arr);
  $usuario = $session->read('login.usuario')->nome;
  
?>
	<table style="font-size:12px">
		<tr>
			<td>
				<b>Relatório:</b> <?=$nomeRelatorio?>
				<br>
				<b>Emissão:</b> <?=$dataHora?>
				<br>
				<b>Usuário:</b> <?=$usuario?>
				<br>
				<b>Período:</b> <?=$periodo?>
				<br>
				<b>Total de registros:</b> <?=$totalRegistros?>
				<?php
					foreach($totalizadores as $total){
						echo '<br><b>'.$total['label'].':</b> '.$this->Custom->format($total['format'],$total['valor']);
					}
				?>
			</td>
		</tr>
	</table>
	
	<?php if(count($arr) > 0){ ?>
	<table class="table  table-striped table-bordered display compact" id="datatable2">
		<thead>
			<tr>
			<th></th>
			<?php 
				foreach($colunas as $key=>$item){
					echo "<th>".$item."</th>";
				}
			?>
			</tr>
		</thead>
		<tbody>
		<?php
			$counterColuna = 0;
			foreach ($arr as $key=>$item){
				
				$item = (array) $item;
				$onclick = "";
				if($idregistro == null){
					echo "<tr>";
				}else{
					echo "<tr style='cursor:pointer'>";
					$onclick = "onclick='window.open(\"$linkRegistro".$item[$idregistro]."\")'";
				}
				
				echo "<td style='padding:7px;text-align:right'>".($key+1)."</td>";
				$counterColuna = 0;
				foreach($item as $subkey=>$subitem){
					//terminar com _ pula o registro
					if($this->Custom->endsWith($subkey,"_")){
						continue;
					}
					echo "<td $onclick style='padding:7px'>".$this->Custom->format($format[$counterColuna],$subitem)."</td>";
					
					$counterColuna++;
					
				}
				echo "</tr>";
			}
		?>
		</tbody>
	</table>
	<?php } //fim if detalhado?>
	
	<script>		
		var datatable2 = $("#datatable2").DataTable({
			responsive: true,
			retrieve: false,
			paging : true,
			scroll : true,
			fixedHeader: {
			  header: true,
			  footer: false
			},
			language: {
				url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
				decimal: ",",
				thousands: "."
			},
			dom: 'Bfrtip',
			buttons: [
				{
				  extend: 'copy',
				  text: 'Copiar'
				},
				{
				  extend: 'print',
				  text: 'Imprimir',
				  messageTop: 'Relatório: <?=$nomeRelatorio?> <?=$periodo?>  \n Usuário: <?=$usuario?> \n Emitido em: <?=$dataHora?>'
				},
				{
				  extend: 'excel',
				  filename: 'Flygestor - <?=$nomeRelatorio?> <?=$periodo?>',
				  text: 'Excel',
				  exportOptions: {
                		columns: ':visible',
                		format: {
                    		body: function(data, row, column, node) {
                        		return data.replace('.','').replace(',', '.');
                    		}
 
                		}
           		 },
				   messageTop: '<?=$nomeRelatorio?> <?=$periodo?> | Usuário: <?=$usuario?> | Emitido em: <?=$dataHora?> | Total de registros: <?=$totalRegistros?>'
				},
				{
				  extend: 'pdf',
				  //Name the pdf
				  filename: 'Flygestor - <?=$nomeRelatorio?> <?=$dataTraco?>',
				  text: 'PDF',
				  orientation:'landscape',
				  title:'FlyGestor',
				  pageSize:'A4',
				  messageTop: 'Relatório: <?=$nomeRelatorio?> <?=$periodo?>  \n Usuário: <?=$usuario?> \n Emitido em: <?=$dataHora?> \n Total de registros: <?=$totalRegistros?>',
				  messageBottom:'Flygestor - <?=$nomeRelatorio?> <?=$periodo?> | Usuário: <?=$usuario?> | Emitido em: <?=$dataHora?> | Total de registros: <?=$totalRegistros?>'
				  ,customize: function(doc) {
					  doc.defaultStyle.fontSize = 8;
					  doc.styles.tableHeader.fontSize = 8;
				  } 
				}
			]  
		});
	</script>
	
	<script>
	jQuery.fn.dataTable.Api.register( 'sum()', function ( ) {
		return this.flatten().reduce( function ( a, b ) {
			if ( typeof a === 'string' ) {
				a = a.replace('.','');
				a = a.replace(',','.');
				a = a.replace(/[^\d.-]/g, '') * 1;
			}
			if ( typeof b === 'string' ) {
				b = b.replace('.','');
				b = b.replace(',','.');
				b = b.replace(/[^\d.-]/g, '') * 1;
			}
	 
			return a + b;
		}, 0 );
	} );
		
	function totalcoluna(){
		var coluna = $('#selectcoluna').val();
		var resultado = datatable2.column( coluna,{"filter": "applied"}  ).data().sum();
		$('#totalresultadocoluna').html((Number(resultado).toFixed(2)).replace('.',','));
	}
	
	setTimeout(function(){
		$("input[type='search']").on( "keyup", function() {
			totalcoluna();
		});
	}, 3000);
	
	for(i = 0;i < $('#datatable2 th').length; i++){
		$("#selectcoluna").append('<option value="'+i+'">'+$('#datatable2 th')[i].innerHTML+'</option>');
	}
	</script>
<script>
	$('#datatable2 th').css('padding','2px');
	$('#datatable2 td').css('padding','2px');
	$('#datatable2 td').css('max-width','150px');
</script>