<?php

?>
<div class="card">
	<div class="card-header">
		<h3>Relatórios</h3>
	</div>
	<div class="card-body">
			<div class="row">
				<div class="col-md-4">
					<b>Relatório</b>
					<select id="selectrelatorio" class="form-control" onchange="escolherrelatorio(value)">
						<option value="-1">.: ESCOLHA O RELATÓRIO :.</option>						
						<option value="leadspororigem">CLI.1 | Leads por vendedor e origem</option>
						<option value="leadsporempresacidade">CLI.2 | Leads por cidade e estado</option>
						<option value="leadsporempresavendedorcidade">CLI.3 | Leads por vendedor e cidade</option>
						<option value="origemporcidade">CLI.4 | Origem de Leads por cidade</option>
						<option value="leadsconvertidas">CLI.5 | Leads convertidas</option>
						<option value="contatoobservacao">CON.1 | Negociações - Observações e Laudos</option>
						<option value="vendedorstatus">CON.2 | Negociações por vendedor</option>
						<option value="leadsporempresavendedorcidadestatus">CON.3 | Negociações por vendedor, cidade e status</option>
						<option value="vendedortempoquantitativo">VEN.1 | Tempo de atendimento por vendedor (quantitativo)</option>
						<option value="vendedortempoqualitativo">VEN.2 | Tempo de atendimento por vendedor (qualitativo)</option>
					</select>
				</div>
				<div class="col-md-4">
					<b>Período</b>
					<div class='input-group'>
						<input value="<?=date('d/m/Y').' - '.date('d/m/Y')?>" name="periodo" id="filtroperiodo" type='text' class="form-control shawCalRanges" />
					</div>
				</div>
				<div class="col-md-4">
					<?php if(in_array($perfilid,[1,2,7])){?>
					<b>Empresas</b>
					<select id="filtroempresa" class="form-control" name="empresaid[]" multiple>
						<?php foreach ($empresas as $item):?>
							<option value="<?=$item->empresaid?>" selected><?=($item->nomefantasia) ? $item->nomefantasia : $item->razaosocial?></option>
						<?php endforeach; ?>
					</select>
					<?php } ?>
				</div>
			</div>
			<br>
			<button class="btn btn-primary" onclick="abrirrelatorio()">Abrir</button>
			<hr>
			<div id="divrelatorio" style="width:100%">
			</div>
			
	</div>
</div>
<script>
	
	function escolherrelatorio(value){
		switch (value){
			case 'leadspororigem':
				$('filtroperiodo').show();
				$('filtroempresa').show();
				$('filtrovendedor').show();
				break;
			case 'contatoobservacao':
				$('filtroperiodo').show();
				$('filtroempresa').show();
				$('filtrovendedor').show();
				break;
			case 'vendedorstatus':
				$('filtroperiodo').show();
				$('filtroempresa').show();
				$('filtrovendedor').show();
				break;
			default:
				$('filtroperiodo').hide();
				$('filtroempresa').hide();
				$('filtrovendedor').hide();
		}
	}
	
	function abrirrelatorio(){
		var relatorio = $('#selectrelatorio').val();
		if(relatorio == '-1'){
			alert('Escolha o relatório');
			return;
		}
		
		var periodo    = ($('#filtroperiodo').length == 0) ? '' : $('#filtroperiodo').val();
		var empresa    = ($('#filtroempresa').length == 0) ? '' : $('#filtroempresa').val().join(',');
		
		var params = "";
		params=params+ 'periodo='+periodo+'&';
		params=params+ 'empresa='+empresa+'&';
		
		var url = encodeURI('relatorio/'+relatorio+'?'+params);
		$('#loading').show();
		$('#divrelatorio').load(url,function(responseText, textStatus, req){
			$('#loading').hide();
			if (textStatus == "error") {
				//alert('Não pudemos completar a solicitação');
				$('#divrelatorio').html(responseText);
			}
		})
	}

</script>
<script>
	setTimeout(function() {
		var f = "DD/MM/Y";
		$('.shawCalRanges').daterangepicker({
			ranges: {
				'Hoje': [moment().format(f), moment().format(f)],
				'Ontem': [moment().subtract(1, 'days').format(f), moment().subtract(1, 'days').format(f)],
				'Últimos 7 dias': [moment().subtract(6, 'days').format(f), moment().format(f)],
				'Esse mês': [moment().startOf('month').format(f), moment().endOf('month').format(f)],
				'Mês passado': [moment().subtract(1, 'month').startOf('month').format(f), moment().subtract(1, 'month').endOf('month').format(f)],
				'Esse ano': [moment().startOf('year').format(f), moment().endOf('year').format(f)],
				'Ano passado': [moment().subtract(1, 'year').startOf('year').format(f), moment().subtract(1, 'year').endOf('year').format(f)]
			},
			locale: {
				format: 'DD/MM/YYYY',
				applyLabel: "Ok",
				cancelLabel: 'Cancelar',
				startLabel: 'Início',
				endLabel: 'Fim',
				customRangeLabel: 'Período',
				daysOfWeek: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex','Sáb'],
				monthNames: ['Janeiro','Fevereiro','Março','Abril','Maio','Junho','Julho','Agosto','Setembro','Outubro','Novembro','Dezembro'],
				firstDay: 1
			},
			 alwaysShowCalendars: true,
		});
	}, 1000);
</script>