<?php
$date = new DateTime();
$session = $this->request->session();
$totalRegistros = count($contas);
$usuario = $session->read('login.usuario')->nome;
?>
<div class="card">    
    <div class="card-header">
        <b>Relatório:</b>&nbsp<?= $nomerelatorio ?><br>
        <b>Emissão:</b>&nbsp<?= Date('d/m/Y h:m:i')?><br>
        <b>Usuário:</b>&nbsp<?= $usuario?><br>
        <b>Período:</b>&nbsp<?=$this->Custom->formatData($periodo[0]).' à '.$this->Custom->formatData($periodo[1])?><br>
        <b>Total de Registros:</b>&nbsp<?=$totalRegistros?><br>
    </div>
    <div class="card-body">
		<?=$this->element('tabela_padrao', [
				'data' => $contas,
				'nomeRelatorio' => $nomerelatorio, 
				'usuario' => $usuario, 
				'sistema' => 'FlyStart - Financeiro', 
				'posicoes_soma' => [3,4,5], 
				'id' => 'relatorio_datatable', 
				'headers' => ['ID', 'Cliente/Fornecedor', 'Vencimento', 'Valor (R$)', 'Total Pago (R$)', 'Total Pendente', 'Status'], 
				'columns' => ['contaid', 'nome', 'data_vencimento', 'totalliquido', 'pago', 'baixado', 'status'], 
				'format' => ['toNumber','','formatData','toFloat','toFloat','toFloat',''], 
				'align' => ['','','','text-right','text-right','text-right',''], 
				'pageLength' => 25, 
				'table_title' => '', 
				'onclick_funcao' => 'editconta',
				'onclick_parametro' => 'contaid',
				'mouse_over'=>true,
				'export' => true,
				'pdf_rightalign'=>[3,4,5]
			]);
		?>
    </div>
</div>
<script>
	$('table td').css('padding','5px');
	$('table th').css('padding','18px');
</script>