<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Subgrupoproduto $subgrupoproduto
 */
?>
<div class="card">
<div class="card-header">
	<h3>Subgrupo Produto <?= h($subgrupoproduto->subgrupoprodutoid) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $subgrupoproduto->subgrupoprodutoid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $subgrupoproduto->subgrupoprodutoid], ['confirm' => __('Deseja deletar # {0}?', $subgrupoproduto->subgrupoprodutoid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Nome') ?></th>
            <td><?= h($subgrupoproduto->nome) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Descrição') ?></th>
            <td><?= h($subgrupoproduto->descricao) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pessoa Cadastro') ?></th>
            <td><?= $this->Custom->get('pessoa','pessoaid',$subgrupoproduto->pessoaidcadastro)->nome ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criação',['label'=>'Data Criação']) ?></th>
            <td><?= h($subgrupoproduto->data_criacao) ?></td>
    </table>
</div>
</div>
