<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Telefone $telefone
 */
?>
<div class="card">
<div class="card-header">
		<h3>Cadastrar Telefone</h3>
		<div class="float-right">
			<?php if($usuario != null){?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-user" aria-hidden="true"></i> Ir para usuário', ['controller'=>'usuario','action' => 'edit',$usuario->usuarioid], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?php } ?>
			<?php if($cliente != null){?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-user" aria-hidden="true"></i> Ir para cliente', ['controller'=>'cliente','action' => 'edit',$cliente->clienteid], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?php } ?>
		</div>
</div>
	
<div class="card-body">
	<?= $this->Form->create($telefone) ?>
    <div class="media align-items-stretch bg-gradient-x-primary white">
		<div class="p-1 media-middle">
			<i class="fa fa-phone font-large-1 white"></i>
		</div>
		<div class="media-body p-1">
		  <h5>Cadastrar Telefone</h5>
		</div>
	</div>
	<br>
	<div class="row" >
		<div class="col-md-12">
		<b>Pessoa: </b><?=$pessoa->nome?>
		<br><br>
		<div class="input-group">
			<select name="tipotelefone1">
				<?php
					$tipotelefone = $this->Custom->getAllTableWhere('tipotelefone',[],['nome'=>'asc']);
					foreach($tipotelefone as $item){
						echo "<option value='".$item->nome."'>".$item->nome."</option>";
					}
				?>
			</select>
			<input type="text" name="codigopais1" class="form-control" placeholder="Código do país +55" onkeypress="$(this).mask('00');" value="<?= !empty($numeroTelefone[0]->codigopais) ? $numeroTelefone[0]->codigopais: '55'?>"/>
			<input type="text" name="ddd1" class="form-control" onkeypress="$(this).mask('(00)');" placeholder="DDD (xx)" value="<?= !empty($numeroTelefone[0]->ddd) ? $numeroTelefone[0]->ddd: ''?>"/>
			<input type="text" name="numero1" class="form-control" onkeypress="$(this).mask('00000-0000', {reverse: true})" placeholder="Número xxxxx-xxxx" value="<?= !empty($numeroTelefone[0]->numero) ? $numeroTelefone[0]->numero: ''?>"/>
		</div>
	
		<div class="input-group">
			<select name="tipotelefone2">
				<?php
					
					foreach($tipotelefone as $item){
						echo "<option value='".$item->nome."'>".$item->nome."</option>";
					}
				?>
			</select>
			<input type="text" name="codigopais2" class="form-control" placeholder="Código do país +55" onkeypress="$(this).mask('00');" value="<?= !empty($numeroTelefone[1]->codigopais) ? $numeroTelefone[1]->codigopais: '55'?>"/>
			<input type="text" name="ddd2" class="form-control" onkeypress="$(this).mask('(00)');" placeholder="DDD (xx)" value="<?= !empty($numeroTelefone[1]->ddd) ? $numeroTelefone[1]->ddd: ''?>"/>
			<input type="text" name="numero2" class="form-control" onkeypress="$(this).mask('00000-0000', {reverse: true})" placeholder="Número xxxxx-xxxx" value="<?= !empty($numeroTelefone[1]->numero) ? $numeroTelefone[1]->numero: ''?>"/>
		</div>
		
		<div class="input-group">
			<select name="tipotelefone3">
				<?php
					
					foreach($tipotelefone as $item){
						echo "<option value='".$item->nome."'>".$item->nome."</option>";
					}
				?>
			</select>
			<input type="text" name="codigopais3" class="form-control" placeholder="Código do país +55" onkeypress="$(this).mask('00');" value="<?= !empty($numeroTelefone[2]->codigopais) ? $numeroTelefone[2]->codigopais: '55'?>"/>
			<input type="text" name="ddd3" class="form-control" onkeypress="$(this).mask('(00)');" placeholder="DDD (xx)" value="<?= !empty($numeroTelefone[2]->ddd) ? $numeroTelefone[2]->ddd: ''?>"/>
			<input type="text" name="numero3" class="form-control" onkeypress="$(this).mask('00000-0000', {reverse: true})" placeholder="Número xxxxx-xxxx" value="<?= !empty($numeroTelefone[2]->numero) ? $numeroTelefone[2]->numero: ''?>"/>
		</div>
		</div>
	</div>
	<br>
	<?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>
