<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Telefone[]|\Cake\Collection\CollectionInterface $telefone
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Telefone') ?></h3>
	<div class="float-right">
		<?= $this->Html->link(__('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar'), ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?></li>
	</div>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('telefoneid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('codigopais') ?></th>
                <th scope="col"><?= $this->Paginator->sort('ddd') ?></th>
                <th scope="col"><?= $this->Paginator->sort('numero') ?></th>
                <th scope="col"><?= $this->Paginator->sort('pessoaid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('data_criacao') ?></th>
                <th scope="col"><?= $this->Paginator->sort('pessoaidcadastro') ?></th>
                <th scope="col"><?= $this->Paginator->sort('empresaid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('tipotelefone') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($telefone as $telefone): ?>
            <tr style="cursor:pointer" onclick="window.location.href='telefone/view/<?=$telefone->telefoneid?>'">
                <td><?= $this->Number->format($telefone->telefoneid) ?></td>
                <td><?= h($telefone->codigopais) ?></td>
                <td><?= h($telefone->ddd) ?></td>
                <td><?= h($telefone->numero) ?></td>
                <td><?= $this->Number->format($telefone->pessoaid) ?></td>
                <td><?= h($telefone->data_criacao) ?></td>
                <td><?= $this->Number->format($telefone->pessoaidcadastro) ?></td>
                <td><?= $this->Number->format($telefone->empresaid) ?></td>
                <td><?= h($telefone->tipotelefone) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('primeiro')) ?>
            <?= $this->Paginator->prev('< ' . __('anterior')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('próximo') . ' >') ?>
            <?= $this->Paginator->last(__('último') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Página {{page}} de {{pages}}, mostrando {{current}} registros(s) de total {{count}}')]) ?></p>
    </div>
</div>
</div>
