<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Telefone $telefone
 */
?>
<div class="card">
<div class="card-header">
	<h3>Telefone <?= h($telefone->telefoneid) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
		<?= $this->Html->link('&nbsp;<i class="fa fa-edit fa-2" aria-hidden="true"></i>  Editar', ['action' => 'edit', $telefone->telefoneid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
		<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $telefone->telefoneid], ['confirm' => __('Deseja deletar # {0}?', $telefone->telefoneid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
    <table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Codigopais') ?></th>
            <td><?= h($telefone->codigopais) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Ddd') ?></th>
            <td><?= h($telefone->ddd) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Numero') ?></th>
            <td><?= h($telefone->numero) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Tipotelefone') ?></th>
            <td><?= h($telefone->tipotelefone) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Telefoneid') ?></th>
            <td><?= $this->Number->format($telefone->telefoneid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pessoaid') ?></th>
            <td><?= $this->Number->format($telefone->pessoaid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Pessoaidcadastro') ?></th>
            <td><?= $this->Number->format($telefone->pessoaidcadastro) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Empresaid') ?></th>
            <td><?= $this->Number->format($telefone->empresaid) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('Data Criacao') ?></th>
            <td><?= h($telefone->data_criacao) ?></td>
        </tr>
    </table>
</div>
</div>
