<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Usuario $usuario
 */
?>
<div class="card">
<div class="card-header">
		<h3>Editar Usuario <?=$usuario->usuarioid?></h3>
		<div class="float-right">
			<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Criar', ['action' => 'add'],['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
			<?= $this->Html->link('&nbsp;<i class="fa fa-eye fa-2" aria-hidden="true"></i>  Ver', ['action' => 'view', $usuario->usuarioid], ['class'=>'btn btn-primary','escape'=>false]) ?> 
			<?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>  Deletar', ['action' => 'delete', $usuario->usuarioid], ['confirm' => __('Deseja deletar # {0}?', $usuario->usuarioid),'class'=>'btn btn-primary', 'escape'=>false]) ?>
		</div>
</div>
	
<div class="card-body">
    <?= $this->Form->create($pessoa) ?>
		<h4>Dados Pessoais</h4>
		<div class="row">
			<div class="col-md-6">
			<?php
				//administrador de sistema
				if($perfilid == 1){
					$empresas = $this->Custom->getAllTableWhere('empresa',[],['nomefantasia'=>'asc']);
					echo "<label>Empresa</label>";
					echo "<select name='empresaid' class='form-control'>";
						echo "<option value=''>.: Selecione uma opção :.</option>";
					foreach($empresas as $item){
						$selected = '';
						if($item->empresaid == $pessoa->empresaid){
							$selected = 'selected';
						}
						echo "<option value='".$item->empresaid."' $selected>".$item->nomefantasia."</option>";
					}
					echo "</select>";
				}
			?>
				<?php
				echo $this->Form->control('nome',['class'=>'form-control','label'=>'Nome / Nome Fantasia']);
				echo $this->Form->control('razaosocial',['class'=>'form-control','label'=>'Nome Social / Razão Social']);
				echo $this->Form->control('cpfcnpj',['class'=>'form-control masknumber','label'=>'CPF / CNPJ']);
				echo $this->Form->control('datanascimento', ['class'=>'form-control maskdate','type'=>'text','empty' => true,'label'=>'Data de Nascimento']);
				echo $this->Form->control('cidade',['class'=>'form-control','label'=>'Cidade de Nascimento']);
				echo $this->Form->control('estado',['class'=>'form-control','label'=>'Estado de Nascimento']);
				echo $this->Form->control('pais',['class'=>'form-control','label'=>'País de Nascimento']);
				?>
			</div>
			<div class="col-md-6">
			
				<label>Sexo</label>
				<select name="sexo" class="form-control" id="sexo">
					<option value="">.: Seleciona uma Opção :.</option>
					<option value="FÍSICA"   <?php if($pessoa->sexo == "MASCULINO"){echo "selected";}?>>MASCULINO</option>
					<option value="FEMININO" <?php if($pessoa->sexo == "FEMININO"){echo "selected";}?>>FEMININO</option>
					<option value="OUTRO"    <?php if($pessoa->sexo == "OUTRO"){echo "selected";}?>>OUTRO</option>
				</select>
				
				<label>Tipo Pessoa</label>
				<select name="tipopessoa" class="form-control" id="tipopessoa">
					<option value="">.: Seleciona uma Opção :.</option>
					<option value="FÍSICA"   <?php if($pessoa->tipopessoa == "FÍSICA"){echo "selected";}?>>FÍSICA</option>
					<option value="JURÍDICA" <?php if($pessoa->tipopessoa == "JURÍDICA"){echo "selected";}?>>JURÍDICA</option>
				</select>
				
				<label>Estado Civil</label>
				<select name="estadocivil" class="form-control" >
					<option value="">.: Seleciona uma Opção :.</option>
					<option <?php if($pessoa->estadocivil == "Solteiro"){echo "selected";}?>>Solteiro</option>
					<option <?php if($pessoa->estadocivil == "Casado"){echo "selected";}?>>Casado</option>
					<option <?php if($pessoa->estadocivil == "Separado"){echo "selected";}?>>Separado</option>
					<option <?php if($pessoa->estadocivil == "Divorciado"){echo "selected";}?>>Divorciado</option>
					<option <?php if($pessoa->estadocivil == "Viúvo"){echo "selected";}?>>Viúvo</option>
					<option <?php if($pessoa->estadocivil == "Amasiado"){echo "selected";}?>>Amasiado</option>
				</select>
				<?php
				echo $this->Form->control('email',['class'=>'form-control']);
				echo $this->Form->control('cargo',['class'=>'form-control']);
				echo $this->Form->control('nomemae',['class'=>'form-control','label'=>'Nome da Mãe']);
				echo $this->Form->control('cpfmae',['class'=>'form-control','label'=>'CPF da Mãe']);
				echo $this->Form->control('senha',['class'=>'form-control','label'=>'Nova Senha']);
				?>
			</div>
		</div>
	<br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
</div>
</div>
