<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Usuario[]|\Cake\Collection\CollectionInterface $usuario
 */
?>
<div class="card">
<div class="card-header">
	<h3><?= __('Usuários') ?></h3>
</div>
<div class="card-body">
    <table class="table table-responsive table-striped datatable" id="datatable" >
        <thead>
            <tr>
                <th>Id</th> 
                <th>Nome</th>
                <th>CPF</th>
            </tr>
        </thead>
        <tbody>
			<?php foreach ($usuarios as $item): ?>
			<tr style="cursor:pointer" onclick="window.location.href='usuario/view/<?=$item->idusuario?>'">
				<td><?=$item->idusuario?></td>
				<td><?=$item->nome?></td>
				<td><?=$item->cpf?></td>
			</tr>
			<?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
<script>
	
	var datatable2 = $("#datatable").DataTable({
		responsive: true,
		retrieve: false,
		paging : true,
		scroll : true,
		fixedHeader: {
		  header: true,
		  footer: false
		},
		language: {
			url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
			decimal: ",",
			thousands: "."
		},
		dom: 'Bfrtip',
		buttons: []  
	});
	
</script>
