<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Usuario $usuario
 */
?>
<div class="card">
<div class="card-header">
	<h3>Usuario <?= h($usuario->idusuario) ?></h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-bars" aria-hidden="true"></i> Listar', ['action' => 'index'], ['class'=>'btn btn-primary','escape'=>false]) ?>
	</div>
</div>
<div class="card-body">
	<table class="vertical-table table-responsive table">
        <tr>
            <th scope="row"><?= __('Nome') ?></th>
            <td><?= h($usuario->nome) ?></td>
        </tr>
        <tr>
            <th scope="row"><?= __('CPF') ?></th>
            <td><?= h($usuario->cpf) ?></td>
        </tr>
    </table>
	<hr>
	<h3>Módulos do usuário</h3>
	<div class="float-right">
		<?= $this->Html->link('&nbsp;<i class="fa fa-plus-square fa-2" aria-hidden="true"></i> Cadastrar', ['controller'=>'modulousuario','action' => 'add',$usuario->idusuario],['target'=>'_BLANK','class'=>'btn btn-primary','escape'=>false]) ?>
	</div>
	<table class="table table-responsive table-striped" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
				<th scope="col">Cód.</th>
                <th scope="col">Módulo</th>
                <th scope="col">Data Cadastro</th>
				<th></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($modulos as $item): ?>
			<?php
				$modulo = $this->Custom->get('modulo','idmodulo',$item->idmodulo);
			?>
            <tr>
                <td><?=$modulo->idmodulo?></td>
				<td><?=$modulo->descricao?></td>
				<td><?=h($item->data_criacao)?></td>
				<td><?= $this->Form->postLink('&nbsp;<i class="fa fa-trash fa-2" aria-hidden="true"></i>', ['controller'=>'modulousuario','action' => 'delete', $item->idmodulousuario], ['confirm' => __('Deseja deletar # {0}?', $item->modulousuarioid),'class'=>'btn btn-danger', 'escape'=>false]) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</div>
