<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="especialidade">Qual a especialidade?</label>
                    <select class="form-control" name="especialidade" id="especialidade">
                        <option value="-1" disabled selected>.: Selecione a especialidade que você quer ? :.</option>
                        <?php foreach ($especialidades as $especialidade) { ?>
                            <option value="<?=$especialidade->especialidadeid?>"><?=$especialidade->nome?></option>
                        <?php }?>
                    </select>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="especialidade">Qual a unidade?</label>
                    <select class="form-control" name="unidade" id="unidade" disabled>
                        <option value="-1" disabled selected>.: Selecione a unidade que você quer ? :.</option>
                        
                    </select>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="especialidade">Qual o/a médico(a)?</label>
                    <select class="form-control" name="medico" id="medico" disabled>
                        <option value="-1" disabled selected>.: Selecione o médico que você quer ? :.</option>
                        <option value="0">Qualquer médico</option>
                        
                    </select>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="especialidade">Qual a dia?</label>
                    <input class="form-control" type="date" id="inicio" disabled>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body" id="card-horario" style="display:none;">
        <h5 class="card-title">Selecione qual o dia e horário que você quer se consulta</h5>
        <div class="row" id="horarios">
            
        </div>
    </div>
</div>

<script>
var calendar
    $(document).ready(()=>{
        Date.prototype.toDateInputValue = (function() {
            var local = new Date(this);
            local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
            return local.toJSON().slice(0,10);
        });
        var especialidade;
        var medico;
        $("#especialidade").select2();
        $("#especialidade").change((e)=>{
            if($("#especialidade").val() != "-1"){
                especialidade = $("#especialidade").val();
                var fd = new FormData();
                fd.append("especialidade",especialidade);
                $.ajax({
                    url:"<?=$this->request->getAttribute('base')?>/paciente/telemedicina/getUnidade/"
                    ,type:"POST"
                    ,data:fd,
                    contentType: false,
                    processData: false,
                    cache: false,
                    mimeType: "multipart/form-data",
                    dataType:"json"
                }).done((res)=>{
                    var unidades = JSON.parse(res.json.unidades)
                    unidades.forEach((u)=>{
                        $("#unidade").append("<option value='"+u.hospitalid+"'>"+u.nomefantasia+"</option>");
                    })
                    $("#unidade").prop("disabled",false);
                }).fail((err)=>{
                    Swal.fire(
                        'Opps...',
                        'Por favor contate o suporte',
                        'error'
                    )
                })
                
            }
            
        });
        $("#unidade").change((e)=>{
            if($("#unidade").val() != "-1"){
                unidade = $("#unidade").val();
                var fd = new FormData();
                fd.append("unidade",unidade);
                $.ajax({
                    url:"<?=$this->request->getAttribute('base')?>/paciente/telemedicina/getMedico/"
                    ,type:"POST"
                    ,data:fd,
                    contentType: false,
                    processData: false,
                    cache: false,
                    mimeType: "multipart/form-data",
                    dataType:"json"
                }).done((res)=>{
                    var medico = JSON.parse(res.json.medico)
                    medico.forEach((m)=>{
                        $("#medico").append("<option value='"+m.medicoid+"'>"+m.nome+"</option>");
                    })
                    $("#medico").prop("disabled",false);
                })
            }
        });
        $("#medico").change((e)=>{
            if($("#medico").val() != "-1"){
                medico = $("#medico").val();
                $("#inicio").prop("disabled",false)
            }
        });
        $('#inicio').change(function () {
            var moment = $('#inicio').val();
            gethorario(especialidade,moment,medico)
        });

        $('#inicio').keypress(function (e) {
            $(this).off('change blur');

            $(this).blur(function () {
                var moment = $('#inicio').val();
                gethorario(especialidade,moment,medico)
            });

            if (e.keyCode === 13) {
                var moment = $('#inicio').val();
                gethorario(especialidade,moment,medico)
            }
        });
    })

    function gethorario(especialidade,moment,medico) {
        var fd = new FormData();
        fd.append("especialidade",especialidade);
        fd.append("moment",moment);
        fd.append("medico",medico);
        $.ajax({
            url:"<?=$this->request->getAttribute('base')?>/paciente/telemedicina/getHorarios/"
            ,type:"POST"
            ,data:fd,
            contentType: false,
            processData: false,
            cache: false,
            mimeType: "multipart/form-data",
            dataType:"json"
        }).done((res)=>{
            $("#card-horario").css("display","block")
            $("#horarios").addClass("d-flex justify-content-center");
            $("#horarios").html('<div class="fa-3x"><i class="fas fa-sync fa-spin"></i></div>')
            var horarios = JSON.parse(res.json.horarios)
            var horariosEL = ``;
            horarios.forEach((h)=>{
                var buttonEl = ``;
                for (const [index, [key, value]] of Object.entries(Object.entries(h.horario))) {
                    buttonEl += `<button onclick="confimar(this)" class="btn btn-success mr-1 mt-1" horarioid="`+key+`">`+value+`</button>`         
                }
                horariosEL += `<div class="col-md-12 mb-1 mt-1">
                                <h4 class="font-weight-bold">`+h.inicio+`</h4>
                                <div class="row col-md-4">
                                    `+buttonEl+`
                                </div>
                            </div>`
            })
            $("#horarios").html(horariosEL);
            $("#horarios").removeClass("d-flex justify-content-center");
        })
    }

    function confimar(who) {
        var horarioid = $(who).attr("horarioid");
        var especialidade = $("#especialidade").val();
        var unidade = $("#unidade").val();
        var medico = $("#medico").val();
        $('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
        $('#modal').modal('show').find('.modal-body').load('<?=$this->request->getAttribute('base').'/paciente/telemedicina/preconfirmar/'?>'+especialidade+"/"+unidade+"/"+medico+"/"+horarioid,function(responseText, textStatus, req){
            if (textStatus == "error") {
                alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
                $('[data-dismiss="modal"]').click();
            }else{
                $("#confirma").click((e)=>{
                    e.preventDefault();
                    var url = $("#confirma").attr("href");
                    $.ajax({
                        url:url
                        ,type:"POST",
                        contentType: false,
                        processData: false,
                        cache: false,
                        mimeType: "multipart/form-data",
                        dataType:"json"
                    }).done((res)=>{
                        Swal.fire(
                        'Agendado',
                        'Esteja na data e hora do agendamento',
                        'success'
                        ).then((result) => {
                            if (result.value) {
                                window.location.reload(false);
                            }
                        })
                    }).fail((res)=>{
                        var horarioid = JSON.parse(res.json.horarioid)
                        $("button[attr='"+horarioid+"'").remove();
                        Swal.fire(
                        'Opps...',
                        'Esse horário já não está mais disponível',
                        'error'
                        )
                        $('#modal').modal('hide');
                    })
                })
            }
        });
        $('#loading').hide();
        $('button[data-dismiss="modal"]').on('click', function(e){
            $('.modal-body').html("");
        });
    }

</script>