<div class="card">
    <div class="card-body">
        <h5 class="card-title">Lista de agendamentos</h5>
        <table class="table table-striped" id="tableConsulta">
            <thead>
                <tr>
                    <th>Data e hora consulta</th>
                    <th>Médico</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($consultas as $consulta) { ?>
               <tr>
                    <th data-order="<?=strtotime($consulta->inicio)?>"><?=date("d/m/Y H:i",strtotime($consulta->inicio))?></th>
                    <td><?=$consulta->nome?></td>
                    <td><?=$consulta->status?></td>
                    <td style="width: 28%;">
                        <?php if($consulta->status == "Pendente"){ ?>
                            <a class="btn btn-info" target="_black" href="<?=$this->request->getAttribute('base')?>/paciente/telemedicina/videoconferencia?sala=<?=$consulta->salavirtual?>"><i class="fas fa-video"></i> Entrar na sala</a>
                            <a class="btn btn-danger" type="button" data-toggle="modal" href="<?=$this->request->getAttribute('base')?>/paciente/telemedicina/cancelar?sala=<?=$consulta->salavirtual?>"><i class="fas fa-times"></i> Cancelar</a>
                        <?php }else if($consulta->status == "Realizado"){ ?>
                            <a class="btn btn-warning" target="_black" href="<?=$this->request->getAttribute('base')?>/paciente/telemedicina/avaliacao?sala=<?=$consulta->salavirtual?>"><i class="fas fa-edit"></i> Editar nota</a>
                        <?php }else if($consulta->status == "Cancelada"){ ?>
                            <abbr title="<?=empty($consulta->comentario)  ? !empty($consulta->comentario_usuario) ? $consulta->comentario_usuario : "Sem comentário" : $consulta->comentario?>">Motivo</abbr>
                        <?php }?>
                    </td>
               </tr>
            <?php }?>
            </tbody>
        </table>
    </div>
</div>
<script>
    $(document).ready(function(){
        $('#tableConsulta').DataTable({
            "order": [[ 0, "desc" ]],
		    paging : true,
		    scroll : true,
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            aaSorting: [],
            buttons: [],
            columnDefs: [
                { orderable: false, targets: 3 }
            ]
        })
        $('a[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
    })

</script>