<div class="card">
    <div class="card-body">
        <div class="row">
            <table class="table table-striped" id="medicos">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>CRM</th>
                        <th>Hospital(is)</th>
                        <th><a class='btn btn-primary'href="<?=$this->request->getAttribute('base')?>/secretaria/medico/add/" data-toggle="modal"><i class="fas fa-plus-square"></i> Adicionar</a></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($medico as $value) { ?>
                    <tr>
                        <td><?=$value->nome?></td>
                        <td><?=$value->crm?></td>
                        <td><?=$value->hospitais?></td>
                        <td><button class="btn btn-warning" href="<?=$this->request->getAttribute('base')?>/secretaria/medico/edit/<?=$value->medicoid?>" onclick="editMedico(this)"><i class="fas fa-edit"></i> Editar</b></td>
                    </tr>
                  <?php }?>
                </tbody>        
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function(){
        $('#medicos').DataTable({
            "order": [[ 0, "desc" ]],
		    paging : true,
		    scroll : true,
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            aaSorting: [],
            buttons: [],
            columnDefs: [
                { orderable: false, targets: 3 }
            ]
        })
    })

    function editMedico(who) {
        var url = $(who).attr("href");
        $('#modal .modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
        $('#modal').modal('show').find('.modal-body').load(url,function(responseText, textStatus, req){
            if (textStatus == "error") {
                alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
                $('[data-dismiss="modal"]').click();
            }else{
                $("#formHorario").off().on('submit', function(e){
                    e.preventDefault()
                    var fd = new FormData($("#formHorario")[0]);
                    $.ajax({
                        url:url
                        ,type:"POST"
                        ,data:fd,
                        contentType: false,
                        processData: false,
                        cache: false,
                        mimeType: "multipart/form-data",
                        dataType:"json"

                    }).done((res)=>{
                        loadHorarios();
                        Swal.fire({
                            icon: 'success',
                            title: 'Salvo com sucesso',
                            text: ''
                        });
                    }).fail((jqXHR, textStatus, msg)=>{
                        loadHorarios();
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: msg
                        });
                    })
                });
            }
        });
        $('#loading').hide();

        $('button[data-dismiss="modal"]').on('click', function(e){
            $('.modal-body').html("");
        });
    }
</script>