<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-8">
            <div id="calendar"></div>
            </div>
            <div class="col-md-4">
                <div class="card-header bg-light mb-1">
                    Consulta
                </div>
                <div class="d-flex justify-content-center">
                    <h3 class="font-weight-bold" id="titulo"></h3>
                    
                </div>
                <hr>
                <h5 id="dia">Selecione uma consulta para obter mais informações</h5>
                <h5 id="medico"></h5>
                <h5 id="local"></h5>
                <h5 id="paciente"></h5>
                <h5 id="status"></h5>
                <div class="mt-2" id="acao">
                </div>
            </div>
        </div>

    </div>
</div>
<link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.5.1/main.min.css' rel='stylesheet' />
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.5.1/main.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.5.1/locales-all.min.js'></script>
<script>
var ELantigo;
    $(document).ready(()=>{
        var calendarEl = document.getElementById('calendar');
        var calendar = new FullCalendar.Calendar(calendarEl, {
          initialView: 'dayGridMonth',
          locale:"pt-br",
          eventSources:[{
            url: '<?=$this->request->getAttribute('base')?>/secretaria/telemedicina/agendamentosconferencia',
            method: 'POST'
          }],
            eventSourceSuccess: function(content, xhr) {
                return content.eventArray;
            },
            eventClick:function (info) {
                if(ELantigo){
                    ELantigo.el.style.background = ""
                }
                info.el.style.background = "rgba(0,0,0,.1)"
                ELantigo = info
                var titulo = info.event.title
                var dia = info.event.start
                var local = info.event.extendedProps.hospital
                var paciente = info.event.extendedProps.paciente
                var status = info.event.extendedProps.status;
                var salavirtual = info.event.extendedProps.salavirtual;
                var horariomedicoid = info.event.extendedProps.horariomedicoid;
                var medico = info.event.extendedProps.medico;
                var acao = "";
                if(paciente == null){
                    paciente = "Sem paciente";
                }
                if(status == "Disponível"){
                    acao = `<button class="btn btn-danger" onclick="retirarhorario(this)" horarioid="`+horariomedicoid+`">Retirar disponibilidade</button>`;
                }
                if(status == "Agendada"){
                    acao = `<button class="btn btn-danger" onclick="cancelarConsulta(this)" horarioid="`+horariomedicoid+`">Cancelar consulta</button>`;
                }
                var options = { weekday: 'long', month: 'long', day: 'numeric' }
                dia = dia.toLocaleString('pt-BR', options)
                dia = dia[0].toUpperCase() + dia.substr(1)
        
                $("#titulo").html(titulo)
                $("#dia").html(dia)
                $("#medico").html("Médico: "+medico)
                $("#local").html('<a target="_black" href="https://www.google.com/maps/search/?api=1&query='+local.replace(" ","+")+'"><i class="fas fa-map-marker-alt"></i> '+local+'</a>')
                $("#paciente").html("Paciente: "+paciente)
                $("#status").html("Status: "+status)
                $("#acao").html(acao)

            }
        });
        calendar.render();
    })

    function cancelarConsulta(who) {
        var horarioid = $(who).attr("horarioid");
        $('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
        $('#modal').modal('show').find('.modal-body').load('<?=$this->request->getAttribute('base').'/secretaria/telemedicina/cancelarConsulta/'?>'+horarioid,function(responseText, textStatus, req){
            if (textStatus == "error") {
                alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
                $('[data-dismiss="modal"]').click();
            }
        });
        $('#loading').hide();

        $('button[data-dismiss="modal"]').on('click', function(e){
            $('.modal-body').html("");
        });

    }
    function retirarhorario(who) {
        var horarioid = $(who).attr("horarioid");
        Swal.fire({
            title: 'Tem certeza que você quer retirar essa horário?',
            showDenyButton: true,
            showCancelButton: true,
            confirmButtonText: `Retirar`,
            cancelButtonText:"Deixar"
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.value) {
                    $.ajax({
                        url:"<?=$this->request->getAttribute('base')?>/secretaria/telemedicina/retirarhorario/"+horarioid
                        ,type:"POST",
                        contentType: false,
                        processData: false,
                        cache: false,
                        mimeType: "multipart/form-data",
                        dataType:"json"
                    }).done(()=>{
                        window.location.reload(true);
                    }).fail(()=>{
                        Swal.fire(
                            'Oppss...',
                            'Algum paciente resevou o horário',
                            'error'
                            )
                        window.location.reload(true);
                    })
                } 
            })
    }
</script>