<?php
namespace App\View\Helper;

use Cake\View\Helper;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;
use \Datetime;
use \stdClass;

class CustomHelper extends Helper {

	function toDatetime($value){
		return date_format(date_create($value),'d/m/Y H:i');
	}

	function toDate($value){
		return date_format(date_create($value),'d/m/Y');
	}

	public function getInnerJoin($table1,$table2,$arr1,$arr2,$order){
		$table  = TableRegistry::get($table1);
		$arr = $table
					->find('all')
					->innerJoin($table2, $arr1)
					->where($arr2)
					->order($order)
					->toArray();
		return $arr;
	}
	public function getAllTableWhere($table, $arr, $order=[]){
		$table  = TableRegistry::get($table);
		$arr = $table
					->find('all')
					->where($arr)
					->order($order);
		return $arr;
	}

	public function getUltimoDiaMes($mes=null){
		$ano = date('Y');
		if($mes == null){
			$date = new DateTime('now');
			$date->modify('last day of this month');
			return $date->format('d');
		}else{
			$date = new DateTime("$ano-$mes-01");
			$date->modify('last day of this month');
			return $date->format('d');
		}


	}

	function Mask($mask,$str){

		$str = str_replace(" ","",$str);
		$str = str_replace(".","",$str);
		$str = str_replace("-","",$str);
		$str = str_replace("/","",$str);
	
		for($i=0;$i<strlen($str);$i++){
			$mask[strpos($mask,"#")] = $str[$i];
		}
	
		return $mask;
	}

	function startsWith($haystack, $needle)
	{
		 $length = strlen($needle);
		 return (substr($haystack, 0, $length) === $needle);
	}

	function endsWith($haystack, $needle)
	{
		$length = strlen($needle);

		return $length === 0 ||
		(substr($haystack, -$length) === $needle);
	}

	public function empresaid() {
		$session = $this->request->session();
		$usuario = $session->read('login.usuario');
		$usuario_crm = $this->get('usuario_crm','usuarioid',$usuario->idusuario);
		return $usuario_crm->empresaid;
	}

	public function format($format,$value){
		if($format === null || trim($format) == ""){
			return $value;
		}

		if($value === null || trim($value) == ""){
			return $value;
		}

		$result = $value;
		if($format == "toPerc"){
			$result = str_replace('.',',',round($value,2))."%";
		}
		if($format == "toMoney"){
			$result = $this->toMoney($value);
		}
		if($format == "toNumber"){
			$result = $this->toNumber($value);
		}
		if($format == "toMes"){
			$result = $this->toMes($value);
		}
		if($format == "formatData"){
			$result = $this->formatData($value);
		}
		if($format == "truncate"){
			$result = $this->truncate($value);
		}
		if($format == "toFloat"){
			$result = $this->toFloat($value);
		}

		return $result;

	}

	public function truncate($value){
		if($value == null ){
			return "";
		}

		if (strlen($value) > 50){
			$value = substr($value, 0, 48) . '...';
		}
		return $value;
	}

	public function truncate2($value){
		if($value == null ){
			return "";
		}

		if (strlen($value) > 50){
			$value = substr($value, 0, 110) . '...';
		}
		return $value;
	}

	public function toPerc($number,$total){
		if($number == "" || $number == null || $number == 0){
			return "0%";
		}
		if($total == "" || $total == null || $total == 0){
			return "0%";
		}
		return str_replace('.',',',round(($number/$total*100),2))."%";
    }

    public function toPerc2($number,$total){
		if($number == "" || $number == null || $number == 0){
			return "0%";
		}
		if($total == "" || $total == null || $total == 0){
			return "0%";
		}
		return str_replace('.',',',round(((($number/$total)-1)*100),2))."%";
	}

	public function toNumber($number){
		return number_format($number, 0, '', '.');
	}

	public function toFloat($number){
		if(is_numeric($number)){
			return number_format($number,2,",",".");
		}
		return 0;
	}

	public function textoLink($text){
		$reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
		if(preg_match($reg_exUrl, $text, $url)) {
			return preg_replace($reg_exUrl, "<a target=\"_BLANK\" href=".$url[0].">".$url[0]."</a> ", $text);
		} else {
			return $text;
		}
	}

	public function cobrancaStatus($cobranca){
		if($cobranca->data_cancelamento != null){
			return "Cancelado";
		}

		if($cobranca->data_pagamento != null){
			return "Pago";
		}

		//debug($this->formatDateToDatabase($cobranca->data_vencimento));exit();
		$data_vencimento=$cobranca->data_vencimento->format('Y-m-d');
		//
		$data_hoje 		=date("Y-m-d");

		if(strtotime($data_vencimento) > strtotime($data_hoje)){
			return "Pendente";
		}else{
			return "Vencido";
		}
	}

	public function toMes($num, $abrev = false){
		if(strlen(trim($num)) == 0){
			return "";
		}

		$mes = [
			'Janeiro',
			'Fevereiro',
			'Março',
			'Abril',
			'Maio',
			'Junho',
			'Julho',
			'Agosto',
			'Setembro',
			'Outubro',
			'Novembro',
			'Dezembro'
		];
		if(!isset($mes[$num-1])){
			echo "Aqui: ".$num;exit();
		}
		$value = $mes[$num-1];

		if($abrev){
			$value = substr($value, 0, 3);
		}

		return $value;
	}

	public function get($table, $column, $value){
		$table  = TableRegistry::get($table);
		$object = $table
						->find('all')
						->where([$column=>$value])
						->first();

		return $object;
	}

	public function getAll($table, $column, $value){
		$table  = TableRegistry::get($table);
		$arr = $table
					->find('all')
					->where([$column=>$value]);
		return $arr;
	}

	public function arrayToObj($arr){
		$object = new stdClass();
		foreach ($arr as $key => $value)
		{
			if(is_float($value) && strlen($value) <= 8) { $value = (float)$value;}

			if(is_numeric($value) && strlen($value) <= 8) { $value = (int)$value;}
			$object->$key = $value;
		}
		return $object;
	}

	public function arrayToArrayObj($arr){
		$arr2 = [];
		foreach ($arr as $key => $value){
			$value2 = $this->arrayToObj($value);
			array_push($arr2,$value2);
		}
		return $arr2;
	}

	public function query($sql){
		$connection = ConnectionManager::get('default');
        $query = $connection->execute($sql)->fetchall('assoc');
		return $this->arrayToArrayObj($query);
	}

	public function isLocalhost(){
		$whitelist = array('127.0.0.1', "::1");

		if(in_array($_SERVER['REMOTE_ADDR'], $whitelist)){
			return true;
		}
		return false;
	}

	public function showPaginator($arr){

		$result = "";
		if(isset($_GET['page']) && $_GET['page'] > 1){
			$p = $_GET['pesquisa'];
			$r = $_GET['page'] -1;
			$result =  $result . " <a class='btn btn-primary' href='".strtok($_SERVER["REQUEST_URI"],'?')."?page=$r&pageTotal=10&pesquisa=$p'> << anterior </a> ";

			$page = $_GET['page'];
			for($i = 0; $i < $page; $i++){
				$y = $i +1;
				if($y == $page){
					$y = "<b>$y</b>";
				}
				$result = $result . " <a class='btn btn-primary' href='".strtok($_SERVER["REQUEST_URI"],'?')."?page=$y&pageTotal=10&pesquisa=$p'> $y </a> ";
			}

			$t = $page+1;
			if(count($arr) == $_GET['pageTotal']){
				$result =  $result . " <a class='btn btn-primary' href='".strtok($_SERVER["REQUEST_URI"],'?')."?page=$t&pageTotal=10&pesquisa=$p'> próxima >> </a> ";
			}

		}else{
			$p = '%';
			if(isset($_REQUEST['pesquisa'])){
				$p = $_REQUEST['pesquisa'];
			}
			if(count($arr) == 10){
				$result = " <a class='btn btn-primary' href='".strtok($_SERVER["REQUEST_URI"],'?')."?page=2&pageTotal=10&pesquisa=$p'> próxima >> </a> ";
			}
		}
		return $result;
	}

    public function toMoney($money,$nowrap = false){
		if($nowrap){
			return "<span style='white-space:nowrap'>R$ ".number_format((float)$money, 2, ',', '.')."</span>";
		}
		return "R$ ".number_format((float)$money, 2, ',', '.');
	}

	public function toSimNao($valor){
		if($valor == 1){
			return "sim";
		}
		return "não";
	}

	public function formatDataHora($dataHora){
		if(strlen($dataHora) == 0){
			return "";
		}

		$date = new DateTime($dataHora);
		return $date->format('d/m/Y H:i:s');
	}

	public function formatDataHoraFromObj($dataHora){
		$date = new DateTime($dataHora);
		$date->modify('-3 hours');
		return $date->format('d/m/Y H:i:s');
	}

	public function formatDataFromObj($data){
		if ($data == null || trim($data) == "" || strtoupper($data) == "NULL"){
			return "";
		}

		$data = explode(" ",$data)[0];
		return $data;
	}

	public function formatData($data){
		$dataoriginal = $data;

		if ($data == null || trim($data) == "" || strtoupper($data) == "NULL"){
			return "";
		}

		if(count(explode(" ",$data)) > 1){
			$data = explode(" ",$data)[0];
		}

		$arrdate = explode('-',$data);

		if(count($arrdate)!=3){
			return $dataoriginal;
		}

		$d = $arrdate[2];
		$m = $arrdate[1];
		$y = $arrdate[0];

		return "$d/$m/$y";
	}

	public function selectSimNao($name, $selected = 1, $comLabel = true){
		$selected1 = "";
		$selected0 = "";

		if($selected == 1){
			$selected1 = "selected";
		}else{
			$selected0 = "selected";
		}

		$valor = "<select id='$name' name='$name' class='form-control'>".
					"<option value='1' $selected1>Sim</option>".
					"<option value='0' $selected0>Não</option>".
				"</select>";

		if($comLabel){
			$nameUC = ucfirst($name);
			$valor = "<label for='$name'>$nameUC</label>".$valor;
		}
		return $valor;
	}

	public function select($arr, $name, $selected = null, $comLabel = true, $label = null){
		$valor = "<select id='$name' name='$name' class='form-control'>";
		foreach($arr as $key => $value){
			$selectedTag = "";
			if($key == $selected){
				$selectedTag = 'selected';
			}
			$value =
			$valor = $valor . "<option value='$key' $selectedTag>$value</option>";
		}
		$valor = $valor . "</select>";

		if($comLabel){
			if(!$label){
				$label = ucfirst($name);
			}
			$valor = "<label for='$name'>$label</label>".$valor;
		}
		return $valor;
	}
}
?>
