<?php
namespace App\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * CarteiracontaFixture
 *
 */
class CarteiracontaFixture extends TestFixture
{

    /**
     * Table name
     *
     * @var string
     */
    public $table = 'carteiraconta';

    /**
     * Fields
     *
     * @var array
     */
    // @codingStandardsIgnoreStart
    public $fields = [
        'cod_unimed' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'cod_empresa' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'razao_social' => ['type' => 'string', 'length' => 300, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'cgc_empresa' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'incl_empresa' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'exc_empresa' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'cod_contrato' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'incl_contrato' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'exc_contrato' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'status_contrato' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'desc_motivo_benef' => ['type' => 'string', 'length' => 200, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'qtde_vidas_contrato' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'num_fatura' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'valor' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'situacao_pgto' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'data_vencimento' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'ult_data_recebimento' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'valor_recebido' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'periodo_faturamento' => ['type' => 'date', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        '_indexes' => [
            'cod_empresa' => ['type' => 'index', 'columns' => ['cod_empresa'], 'length' => []],
            'cod_contrato' => ['type' => 'index', 'columns' => ['cod_contrato'], 'length' => []],
            'codempresa_contrato' => ['type' => 'index', 'columns' => ['cod_empresa', 'cod_contrato'], 'length' => []],
            'cgc_empresa' => ['type' => 'index', 'columns' => ['cgc_empresa'], 'length' => []],
        ],
        '_options' => [
            'engine' => 'InnoDB',
            'collation' => 'utf8_general_ci'
        ],
    ];
    // @codingStandardsIgnoreEnd

    /**
     * Records
     *
     * @var array
     */
    public $records = [
        [
            'cod_unimed' => 1,
            'cod_empresa' => 1,
            'razao_social' => 'Lorem ipsum dolor sit amet',
            'cgc_empresa' => 'Lorem ipsum dolor ',
            'incl_empresa' => 'Lorem ipsum dolor ',
            'exc_empresa' => 'Lorem ipsum dolor ',
            'cod_contrato' => 1,
            'incl_contrato' => 'Lorem ipsum dolor ',
            'exc_contrato' => 'Lorem ipsum dolor ',
            'status_contrato' => 'Lorem ipsum dolor ',
            'desc_motivo_benef' => 'Lorem ipsum dolor sit amet',
            'qtde_vidas_contrato' => 1,
            'num_fatura' => 1,
            'valor' => 1.5,
            'situacao_pgto' => 'Lorem ipsum dolor ',
            'data_vencimento' => '2020-11-04',
            'ult_data_recebimento' => '2020-11-04',
            'valor_recebido' => 1.5,
            'periodo_faturamento' => '2020-11-04'
        ],
    ];
}
