<?php
namespace App\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * EmpresacarteiraFixture
 *
 */
class EmpresacarteiraFixture extends TestFixture
{

    /**
     * Table name
     *
     * @var string
     */
    public $table = 'empresacarteira';

    /**
     * Fields
     *
     * @var array
     */
    // @codingStandardsIgnoreStart
    public $fields = [
        'cod_unimed' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'cod_empresa' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'razao_social' => ['type' => 'string', 'length' => 300, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'cgc_empresa' => ['type' => 'string', 'length' => 30, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'incl_empresa' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'exc_empresa' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'cod_contrato' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'incl_contrato' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'exc_contrato' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        '_indexes' => [
            'cod_empresa' => ['type' => 'index', 'columns' => ['cod_empresa'], 'length' => []],
            'cod_contrato' => ['type' => 'index', 'columns' => ['cod_contrato'], 'length' => []],
            'codempresa_contrato' => ['type' => 'index', 'columns' => ['cod_empresa', 'cod_contrato'], 'length' => []],
            'cgc_empresa' => ['type' => 'index', 'columns' => ['cgc_empresa'], 'length' => []],
        ],
        '_options' => [
            'engine' => 'InnoDB',
            'collation' => 'utf8_general_ci'
        ],
    ];
    // @codingStandardsIgnoreEnd

    /**
     * Records
     *
     * @var array
     */
    public $records = [
        [
            'cod_unimed' => 1,
            'cod_empresa' => 1,
            'razao_social' => 'Lorem ipsum dolor sit amet',
            'cgc_empresa' => 'Lorem ipsum dolor sit amet',
            'incl_empresa' => 'Lorem ipsum dolor ',
            'exc_empresa' => 'Lorem ipsum dolor ',
            'cod_contrato' => 1,
            'incl_contrato' => 'Lorem ipsum dolor ',
            'exc_contrato' => 'Lorem ipsum dolor '
        ],
    ];
}
