<?php
namespace App\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * MetasproducaoFixture
 *
 */
class MetasproducaoFixture extends TestFixture
{

    /**
     * Table name
     *
     * @var string
     */
    public $table = 'metasproducao';

    /**
     * Fields
     *
     * @var array
     */
    // @codingStandardsIgnoreStart
    public $fields = [
        'id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'autoIncrement' => true, 'precision' => null],
        'codproduto' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'produto' => ['type' => 'string', 'length' => 100, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'ano' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'janeiro' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'fevereiro' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'marco' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'abril' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'maio' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'junho' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'julho' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'agosto' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'setembro' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'outubro' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'novembro' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'dezembro' => ['type' => 'decimal', 'length' => 16, 'precision' => 4, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'data_criacao' => ['type' => 'timestamp', 'length' => null, 'null' => true, 'default' => 'CURRENT_TIMESTAMP', 'comment' => '', 'precision' => null],
        'idusuario' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        '_constraints' => [
            'primary' => ['type' => 'primary', 'columns' => ['id'], 'length' => []],
        ],
        '_options' => [
            'engine' => 'InnoDB',
            'collation' => 'utf8_general_ci'
        ],
    ];
    // @codingStandardsIgnoreEnd

    /**
     * Records
     *
     * @var array
     */
    public $records = [
        [
            'id' => 1,
            'codproduto' => 1,
            'produto' => 'Lorem ipsum dolor sit amet',
            'ano' => 1,
            'janeiro' => 1.5,
            'fevereiro' => 1.5,
            'marco' => 1.5,
            'abril' => 1.5,
            'maio' => 1.5,
            'junho' => 1.5,
            'julho' => 1.5,
            'agosto' => 1.5,
            'setembro' => 1.5,
            'outubro' => 1.5,
            'novembro' => 1.5,
            'dezembro' => 1.5,
            'data_criacao' => 1564153035,
            'idusuario' => 1
        ],
    ];
}
