<?php
namespace App\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * UsuarioLoginFixture
 *
 */
class UsuarioLoginFixture extends TestFixture
{

    /**
     * Table name
     *
     * @var string
     */
    public $table = 'usuario_login';

    /**
     * Fields
     *
     * @var array
     */
    // @codingStandardsIgnoreStart
    public $fields = [
        'id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'autoIncrement' => true, 'precision' => null],
        'login_user' => ['type' => 'string', 'length' => 60, 'null' => false, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => 'login - deve ser preenchido com o cpf do usuario', 'precision' => null, 'fixed' => null],
        'senha_user' => ['type' => 'string', 'length' => 20, 'null' => false, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => 'senha', 'precision' => null, 'fixed' => null],
        'id_empresacliente' => ['type' => 'string', 'length' => 10, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => 'id da empresa: 0 - SUPORTE', 'precision' => null, 'fixed' => null],
        'caminho_consulta' => ['type' => 'string', 'length' => 60, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'nome_usuario' => ['type' => 'string', 'length' => 255, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'nome_erp' => ['type' => 'string', 'length' => 20, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'conexao_ip' => ['type' => 'string', 'length' => 50, 'null' => false, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'conexao_porta' => ['type' => 'string', 'length' => 50, 'null' => false, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'conexao_caminho' => ['type' => 'string', 'length' => 255, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'conexao_key' => ['type' => 'string', 'length' => 255, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'bdcliente_host' => ['type' => 'string', 'length' => 100, 'null' => false, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => 'caminho do banco', 'precision' => null, 'fixed' => null],
        'bdcliente_banco' => ['type' => 'string', 'length' => 50, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'bdcliente_usuario' => ['type' => 'string', 'length' => 50, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        'bdcliente_senha' => ['type' => 'string', 'length' => 50, 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => '', 'precision' => null, 'fixed' => null],
        '_constraints' => [
            'primary' => ['type' => 'primary', 'columns' => ['id'], 'length' => []],
        ],
        '_options' => [
            'engine' => 'InnoDB',
            'collation' => 'utf8_general_ci'
        ],
    ];
    // @codingStandardsIgnoreEnd

    /**
     * Records
     *
     * @var array
     */
    public $records = [
        [
            'id' => 1,
            'login_user' => 'Lorem ipsum dolor sit amet',
            'senha_user' => 'Lorem ipsum dolor ',
            'id_empresacliente' => 'Lorem ip',
            'caminho_consulta' => 'Lorem ipsum dolor sit amet',
            'nome_usuario' => 'Lorem ipsum dolor sit amet',
            'nome_erp' => 'Lorem ipsum dolor ',
            'conexao_ip' => 'Lorem ipsum dolor sit amet',
            'conexao_porta' => 'Lorem ipsum dolor sit amet',
            'conexao_caminho' => 'Lorem ipsum dolor sit amet',
            'conexao_key' => 'Lorem ipsum dolor sit amet',
            'bdcliente_host' => 'Lorem ipsum dolor sit amet',
            'bdcliente_banco' => 'Lorem ipsum dolor sit amet',
            'bdcliente_usuario' => 'Lorem ipsum dolor sit amet',
            'bdcliente_senha' => 'Lorem ipsum dolor sit amet'
        ],
    ];
}
