<?php
/*
 * DataTables example server-side processing script.
 *
 * Please note that this script is intentionally extremely simple to show how
 * server-side processing can be implemented, and probably shouldn't be used as
 * the basis for a large complex system. It is suitable for simple use cases as
 * for learning.
 *
 * See http://datatables.net/usage/server-side for full details on the server-
 * side processing requirements of DataTables.
 *
 * @license MIT - http://datatables.net/license_mit
 */
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'SELECT COD_BENEFICIARIO, SUM(VALOR_COMISS) AS COMISSAO FROM VER_NTL_RESUMO_COMISS
WHERE COD_EQUIPE = $codequipe
GROUP BY COD_BENEFICIARIO';
 
// Table's primary key
$primaryKey = 'COD_BENEFICIARIO';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(
    array( 'db' => 'COD_BENEFICIARIO', 'dt' => 0 ),
    array( 'db' => 'COMISSAO',  'dt' => 1 )
);
 
// SQL server connection information
$sql_details = array(
    'user' => 'corps',
    'pass' => 'Corps#123#P',
    'db'   => 'ORAWEB',
    'host' => '100.100.100.5:1521'
    //$key 	= $session->read('login.empresa')->conexao_key;
    //$porta 	= $session->read('login.empresa')->conexao_porta;
    //$erp 	= $session->read('login.empresa')->erp;
    //$pathfileservice = $session->read('login.empresa')->conexao_path;
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
require( 'ssp.class.php' );
 
echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);